package com.small_it_office.flatserve.core.request.bean.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

import com.small_it_office.flatserve.core.process.internal.RequestContext;

/**
 * {@link BeanParameterMapper}̃CX^XǗt@NgNXB
 * {@link BeanParameterMapper}̃CX^X́AServletContextɁAT[ubgPʂŊi[܂B
 * ̃CX^X̊i[E擾K؂ɍs܂B
 */
public class BeanParameterMapperFactory {

	/**
	 * {@link BeanParameterMapper}ServletContextɊi[邽߂̃L[B
	 */
	private static final String READER_MAP_KEY = "com.small_it_office.flatserve.core.bean_parameter_reader_map_key";

	/**
	 * SingletonCX^XB
	 */
	private static BeanParameterMapperFactory instance = new BeanParameterMapperFactory();

	/**
	 * {@link BeanParameterMapper}̗D揇ʂɂďtsComparatorB
	 */
	private final PriorityComparator comparator = new PriorityComparator();

	/**
	 * RXgN^B
	 */
	private BeanParameterMapperFactory() {
	}

	/**
	 * CX^X擾܂B
	 * @return ̃NX̃CX^XB
	 */
	public static BeanParameterMapperFactory getInstance() {
		return instance;
	}

	/**
	 * {@link BeanMappedParameter}̃CX^Xo^܂B
	 * AvP[Vɂ̃\bhŃCX^Xo^邱ƂŁA{@link #getMapper()}\bh
	 * s̃T[ubgɍ킹CX^X擾ł悤ɂȂ܂B
	 * @param servletConfig ServletConfigIuWFNgB
	 * @param reader {@link BeanMappedParameter}̃CX^XB
	 */
	public synchronized void addMapper(ServletConfig servletConfig, BeanParameterMapper reader) {
		String servletName = servletConfig.getServletName();
		ServletContext servletContext = servletConfig.getServletContext();
		@SuppressWarnings("unchecked")
		Map<String, List<BeanParameterMapper>> readersMap = (Map<String, List<BeanParameterMapper>>)servletContext
		        .getAttribute(READER_MAP_KEY);
		if (readersMap == null) {
			readersMap = new HashMap<String, List<BeanParameterMapper>>();
			servletContext.setAttribute(READER_MAP_KEY, readersMap);
		}
		List<BeanParameterMapper> readers = readersMap.get(servletName);
		if (readers == null) {
			readers = new ArrayList<BeanParameterMapper>();
			readers.add(NullBeanParameterMapper.getInstance());
			readersMap.put(servletName, readers);
		}
		readers.add(reader);
		Collections.sort(readers, comparator);
	}

	/**
	 * {@link BeanParameterMapper}̃CX^X擾܂B
	 * ݎs̃T[ubgœo^ꂽCX^XԂ܂B݂ꍇ́A
	 * DxɕׂălXgԂŕԂ܂B
	 * @return {@link BeanParameterMapper}̃CX^XB
	 */
	public BeanParameterMapper getMapper() {
		ServletConfig servletConfig = RequestContext.get().getServletConfig();
		ServletContext servletContext = servletConfig.getServletContext();
		String servletName = servletConfig.getServletName();

		@SuppressWarnings("unchecked")
		Map<String, List<BeanParameterMapper>> readersMap = (Map<String, List<BeanParameterMapper>>)servletContext
		        .getAttribute(READER_MAP_KEY);
		if (readersMap == null) {
			return NullBeanParameterMapper.getInstance();
		}
		List<BeanParameterMapper> readers = readersMap.get(servletName);
		if (readers == null) {
			return NullBeanParameterMapper.getInstance();
		}

		BeanParameterMapper reader = readers.get(0);
		BeanParameterMapper currentReader = reader;
		BeanParameterMapper nextReader;
		for (int i = 1; i < readers.size(); i++) {
			nextReader = readers.get(i);
			currentReader.setNestedReader(nextReader);
			currentReader = nextReader;
		}
		return reader;
	}

	/**
	 * {@link BeanParameterMapper}̗D揇ʂɂďtsComparatorB
	 */
	private static class PriorityComparator implements Comparator<BeanParameterMapper>, Serializable {

		/**
		 * {@inheritDoc}
		 */
		public int compare(BeanParameterMapper o1, BeanParameterMapper o2) {
			return o1.getPriority() - o2.getPriority();
		}
	}

}
