package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;


public class SelectTagValueModifier implements HtmlTagValueModifier {

	public boolean modifyDocument(OutputDocument outputDocument, List<Element> elements, Object responseValue) {
	    boolean modified = false;
	    Element elementByName = elements.get(0);
	    List<Element> optionElements = elementByName.getAllElements("option");
	    if (responseValue instanceof List) {
	    	modified = selectOptionElements(outputDocument, ((List<?>)responseValue).toArray(), optionElements);
	    } else if (responseValue instanceof Object[]) {
	    	modified = selectOptionElements(outputDocument, (Object[])responseValue, optionElements);
	    } else {
	    	modified = insertSelectAttributeToOptionElements(outputDocument, responseValue,
	    	        optionElements);
	    }
	    return modified;
	}

	private boolean selectOptionElements(OutputDocument outputDocument, Object[] responseValue,
            List<Element> optionElements) {
	    boolean modified = false;
	    for (Object responseValueElement : responseValue) {
	    	if (responseValueElement != null) {
	    		modified = insertSelectAttributeToOptionElements(outputDocument,
	    		        responseValueElement, optionElements);
	    	}
	    }
	    return modified;
    }

	private boolean insertSelectAttributeToOptionElements(OutputDocument outputDocument,
	        Object responseValue, List<Element> optionElements) {
		boolean modified = false;
		for (Element optionElement : optionElements) {
			Attributes attributes = optionElement.getAttributes();
			Map<String, String> attributesMap = new LinkedHashMap<String, String>();
			attributes.populateMap(attributesMap, false);
			String selectedKey = "selected";
			Set<String> attributeKeys = attributesMap.keySet();
			
			//selected̑̑啶EHTMLɋLqꂽƂɍ킹
			for (String attributeKey : attributeKeys) {
				if (attributeKey.equalsIgnoreCase("selected")) {
					selectedKey = attributeKey;
					break;
				}
			}

			boolean optionModified = false;
			if (responseValue.toString().equals(optionElement.getAttributeValue("value"))) {
				if (!"selected".equalsIgnoreCase(attributesMap.get(selectedKey))) {
					attributesMap.put(selectedKey, "selected");
					optionModified = true;
				}
			} else {
				if (attributesMap.containsKey(selectedKey)) {
					attributesMap.remove(selectedKey);
					optionModified = true;
				}
			}
			if (optionModified) {
				outputDocument.replace(attributes, attributesMap);
				modified = true;
			}
		}
		return modified;
	}

	public boolean responsible(String elementName) {
		return "select".equals(elementName);
	}

}
