package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;


public class OptionTagValueModifier implements HtmlTagValueModifier {

	public boolean modifyDocument(OutputDocument outputDocument, List<Element> elements, Object responseValue) {
		boolean selected;
		Element element = elements.get(0);

		if (responseValue instanceof Boolean) {
			selected = (Boolean)responseValue;
		} else if (ModifierUtil.matchesAny(responseValue.toString().toLowerCase(), "false", "")) {
			selected = false;
		} else {
			selected = true;
		}

		Attributes attributes = element.getAttributes();
		Map<String, String> attributesMap = new LinkedHashMap<String, String>();
		attributes.populateMap(attributesMap, false);
		String selectedKey = "selected";
		Set<String> attributeKeys = attributesMap.keySet();
		for (String attributeKey : attributeKeys) {
			if (attributeKey.equalsIgnoreCase("selected")) {
				selectedKey = attributeKey;
				break;
			}
		}

		boolean modified = false;
		if (selected) {
			if (!"selected".equalsIgnoreCase(attributesMap.get(selectedKey))) {
				attributesMap.put(selectedKey, "selected");
				modified = true;
			}
		} else {
			if (attributesMap.containsKey(selectedKey)) {
				attributesMap.remove(selectedKey);
				modified = true;
			}
		}
		if (modified) {
			outputDocument.replace(attributes, attributesMap);
		}
		return modified;
	}

	public boolean responsible(String elementName) {
		return "option".equals(elementName);
	}

}
