package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;


public class HtmlDocumentProcessor {

	private Set<HtmlTagValueModifier> modifiersByName = new HashSet<HtmlTagValueModifier>();
	private Set<HtmlTagValueModifier> modifiersById = new HashSet<HtmlTagValueModifier>();
	private HtmlTagValueModifier nullModifier = new NullTagValueModifier();
	
	public HtmlDocumentProcessor() {
		modifiersByName.add(new InputTagByNameValueModifier());
		modifiersByName.add(new TextAreaTagValueModifier());
		modifiersByName.add(new SelectTagValueModifier());
		
		modifiersById.add(new TagTextValueModifier());
		modifiersById.add(new ListTagValueModifier());
		modifiersById.add(new ATagHrefValueModifier());
		modifiersById.add(new ImgTagSrcValueModifier());
		modifiersById.add(new TableTagValueModifier());
		modifiersById.add(new InputTagByIdValueModifier());
		modifiersById.add(new OptionTagValueModifier());
		modifiersById.add(new SelectTagValueModifier());
	}
	
	public String process(Source source, Map<String, Object> responseValues) {
		Set<Map.Entry<String, Object>> entries = responseValues.entrySet();

		for (Map.Entry<String, Object> entry : entries) {
			Object responseValue = responseValues.get(entry.getKey());
			OutputDocument outputDocument = new OutputDocument(source);
			Element element = source.getElementById(entry.getKey());
			if (element == null) {
				List<Element> elementsByName = source.getAllElements("name", Pattern.compile(entry.getKey()));
				if (elementsByName.size() > 0) {
					String elementName = elementsByName.get(0).getName();
					boolean modified = getModifier(elementName, modifiersByName).modifyDocument(outputDocument, elementsByName, responseValue);
					if (modified) {
						source = new Source(outputDocument.toString());
					}
				}
			} else {
				String elementName = element.getName();
				List<Element> elementList = new ArrayList<Element>();
				elementList.add(element);
				boolean modified = getModifier(elementName, modifiersById).modifyDocument(outputDocument, elementList, responseValue);
				if (modified) {
					source = new Source(outputDocument.toString());
				}
			}
		}

	    return source.toString();
	}
	
	private HtmlTagValueModifier getModifier(String elementName, Set<HtmlTagValueModifier> modifiers) {
		for (HtmlTagValueModifier modifier : modifiers) {
			if (modifier.responsible(elementName)) {
				return modifier;
			}
		}
		return nullModifier;
	}
}
