package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.List;

import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.OutputDocument;



public class ATagHrefValueModifier implements HtmlTagValueModifier {

	public boolean modifyDocument(OutputDocument outputDocument, List<Element> elements, Object responseValue) {
	    boolean modified = false;
	    Element element = elements.get(0);
	    String attributeName = "href";
	    String newTagText = ModifierUtil.insertAttributeValue(element, attributeName, responseValue);
	    EndTag end = element.getEndTag();
	    if (newTagText != null) {
	    	if (end != null) {
	    		newTagText += end.toString();
	    	}
	    	outputDocument.replace(element, newTagText);
	    	modified = true;
	    }
	    return modified;
	}

	public boolean responsible(String elementName) {
		return "a".equals(elementName);
	}

}
