package com.small_it_office.flatserve.purehtml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import net.htmlparser.jericho.Source;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.response.Response;
import com.small_it_office.shared.meslog.message.Message;
import com.small_it_office.flatserve.purehtml.internal.document.HtmlDocumentProcessor;

public class PureHtmlResponse extends Response {

	/**
	 * eLXg̃GR[fBOB
	 */
	private String encoding = null;

	private Map<String, Object> responseValues = new HashMap<String, Object>();

	private String htmlFilePath;

	private Source source;

	private HtmlDocumentProcessor documentProcessor = new HtmlDocumentProcessor();

	public PureHtmlResponse(String htmlFilePath) {
		if (htmlFilePath == null) {
			throw new IllegalArgumentException(Message.get("FSPHT-ERR004"));
		}
		this.htmlFilePath = htmlFilePath;
	}

	@Override
	protected String getContentType() {
		if (source.isXML()) {
			return "application/xhtml+xml";
		} else {
			return "text/html";
		}
	}

	public String getEncoding() {
		return encoding;
	}

	public void setEncoding(String encoding) {
		if (!Charset.isSupported(encoding)) {
			throw new IllegalArgumentException(Message.get("FSPHT-ERR005", encoding));
		}
		this.encoding = encoding;
	}

	public void putValue(String idOrName, Object value) {
		if (idOrName == null) {
			throw new IllegalArgumentException(Message.get("FSPHT-ERR006"));
		}
		if (value == null) {
			throw new IllegalArgumentException(Message.get("FSPHT-ERR007"));
		}
		responseValues.put(idOrName, value);
	}

	public void loadSource(PureHtmlConfig config) {
		String webInfPath;
		if (htmlFilePath.startsWith("/")) {
			webInfPath = "/WEB-INF" + htmlFilePath;
		} else {
			webInfPath = "/WEB-INF/" + htmlFilePath;
		}
		InputStream stream = RequestContext.get().getServletConfig().getServletContext().getResourceAsStream(webInfPath);

		if (stream == null && config.isAvailableClasspathForHtmlSource()) {
			stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(htmlFilePath);
		}

		if (stream == null) {
			throw new CannotLoadHtmlException(Message.get("FSPHT-ERR002", htmlFilePath));
		}

		if (encoding != null) {
			InputStreamReader reader;
			try {
				reader = new InputStreamReader(stream, encoding);
			} catch (UnsupportedEncodingException e) {
				throw new UnexpectedException(e);
			}
			try {
				source = new Source(reader);
			} catch (IOException e) {
				throw new CannotLoadHtmlException(Message.get("FSPHT-ERR003", htmlFilePath), e);
			}
		} else {
			try {
				source = new Source(stream);
			} catch (IOException e) {
				throw new CannotLoadHtmlException(Message.get("FSPHT-ERR003", htmlFilePath), e);
			}
		}

	}

	@Override
	protected void writeResponse() throws IOException {
		String html = documentProcessor.process(source, responseValues);

		HttpServletResponse response = RequestContext.get().getHttpServletResponse();
		if (encoding != null) {
			response.setCharacterEncoding(encoding);
		} else {
			response.setCharacterEncoding(source.getEncoding());
		}
		PrintWriter out = response.getWriter();
		out.write(html);
	}


}
