/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.rule.internal;

import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.internal.util.TypeConvertUtil;
import com.small_it_office.flatserve.validator.rule.MaxDigits;
import com.small_it_office.flatserve.validator.rule.ValidationRule;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;

public class MaxDigitsRule
implements ValidationRule {
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public String getMessage(MessageResource messageResource, String valueString, Annotation annotation) {
        String specified = ((MaxDigits)annotation).message();
        int maxInteger = ((MaxDigits)annotation).integer();
        int maxFraction = ((MaxDigits)annotation).fraction();
        if (maxInteger == Integer.MAX_VALUE) {
            specified = "{message.error.max_digits.fraction}";
        } else if (maxFraction == 0) {
            specified = "{message.error.max_digits.integer}";
        }
        return ErrorUtil.createMessage(messageResource, specified, valueString, maxInteger, maxFraction);
    }

    public boolean isValid(Object value, String valueString, Annotation annotation) {
        if (valueString == null) {
            this.logger.debug("FSVLD-LOGD018", new Object[]{this.ruleName(annotation)});
            return true;
        }
        BigDecimal bValue = TypeConvertUtil.bigDecimalValueOf(value);
        if (bValue == null) {
            this.logger.debug("FSVLD-LOGD019", new Object[]{valueString, this.ruleName(annotation)});
            return false;
        }
        int maxFraction = ((MaxDigits)annotation).fraction();
        int maxInteger = ((MaxDigits)annotation).integer();
        boolean fractionValid = bValue.scale() <= maxFraction;
        boolean integerValid = bValue.precision() - bValue.scale() <= maxInteger;
        return fractionValid & integerValid;
    }

    private String ruleName(Annotation annotation) {
        return annotation.annotationType().getSimpleName();
    }
}

