/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.mapping.internal;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.request.internal.ByteArrayParameterMapping;
import com.small_it_office.flatserve.core.request.internal.HttpServletRequestParameterMapping;
import com.small_it_office.flatserve.core.request.internal.HttpServletResponseParameterMapping;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapping;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMappingFactory;
import com.small_it_office.flatserve.core.request.internal.ServletConfigParameterMapping;
import com.small_it_office.flatserve.core.request.internal.UnsupportedParameterMapping;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.mapping.internal.BeanValidationParameterMapping;
import com.small_it_office.flatserve.validator.mapping.internal.ValidationArrayParameterMapping;
import com.small_it_office.flatserve.validator.mapping.internal.ValidationParameterMapping;
import com.small_it_office.flatserve.validator.type.internal.BigDecimalArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.BigDecimalTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.DateArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.DateTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.DoubleArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.DoubleTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.FloatArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.FloatTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.IntegerArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.IntegerTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.LongArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.LongTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.PrimitiveDoubleArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.PrimitiveDoubleTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.PrimitiveFloatArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.PrimitiveFloatTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.PrimitiveIntArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.PrimitiveIntTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.PrimitiveLongArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.PrimitiveLongTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.StringArrayTypeValidation;
import com.small_it_office.flatserve.validator.type.internal.StringTypeValidation;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRequestParameterMappingFactory
implements RequestParameterMappingFactory {
    private Map<Class<?>, RequestParameterMapping> typeMapping = new HashMap();
    private MessageResource messageResource;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public ValidationRequestParameterMappingFactory(MessageResource messageResource, Config config) {
        this.messageResource = messageResource;
        this.typeMapping.put(String.class, new ValidationParameterMapping<String>(messageResource, new StringTypeValidation()));
        this.typeMapping.put(String[].class, new ValidationArrayParameterMapping<String[]>(messageResource, new StringArrayTypeValidation()));
        this.typeMapping.put(Integer.class, new ValidationParameterMapping<Integer>(messageResource, new IntegerTypeValidation()));
        this.typeMapping.put(Integer[].class, new ValidationArrayParameterMapping<Integer[]>(messageResource, new IntegerArrayTypeValidation()));
        this.typeMapping.put(Integer.TYPE, new ValidationParameterMapping<Integer>(messageResource, new PrimitiveIntTypeValidation()));
        this.typeMapping.put(int[].class, new ValidationArrayParameterMapping<int[]>(messageResource, new PrimitiveIntArrayTypeValidation()));
        this.typeMapping.put(Long.class, new ValidationParameterMapping<Long>(messageResource, new LongTypeValidation()));
        this.typeMapping.put(Long[].class, new ValidationArrayParameterMapping<Long[]>(messageResource, new LongArrayTypeValidation()));
        this.typeMapping.put(Long.TYPE, new ValidationParameterMapping<Long>(messageResource, new PrimitiveLongTypeValidation()));
        this.typeMapping.put(long[].class, new ValidationArrayParameterMapping<long[]>(messageResource, new PrimitiveLongArrayTypeValidation()));
        this.typeMapping.put(Float.class, new ValidationParameterMapping<Float>(messageResource, new FloatTypeValidation()));
        this.typeMapping.put(Float[].class, new ValidationArrayParameterMapping<Float[]>(messageResource, new FloatArrayTypeValidation()));
        this.typeMapping.put(Float.TYPE, new ValidationParameterMapping<Float>(messageResource, new PrimitiveFloatTypeValidation()));
        this.typeMapping.put(float[].class, new ValidationArrayParameterMapping<float[]>(messageResource, new PrimitiveFloatArrayTypeValidation()));
        this.typeMapping.put(Double.class, new ValidationParameterMapping<Double>(messageResource, new DoubleTypeValidation()));
        this.typeMapping.put(Double[].class, new ValidationArrayParameterMapping<Double[]>(messageResource, new DoubleArrayTypeValidation()));
        this.typeMapping.put(Double.TYPE, new ValidationParameterMapping<Double>(messageResource, new PrimitiveDoubleTypeValidation()));
        this.typeMapping.put(double[].class, new ValidationArrayParameterMapping<double[]>(messageResource, new PrimitiveDoubleArrayTypeValidation()));
        this.typeMapping.put(BigDecimal.class, new ValidationParameterMapping<BigDecimal>(messageResource, new BigDecimalTypeValidation()));
        this.typeMapping.put(BigDecimal[].class, new ValidationArrayParameterMapping<BigDecimal[]>(messageResource, new BigDecimalArrayTypeValidation()));
        this.typeMapping.put(Date.class, new ValidationParameterMapping<Date>(messageResource, new DateTypeValidation()));
        this.typeMapping.put(Date[].class, new ValidationArrayParameterMapping<Date[]>(messageResource, new DateArrayTypeValidation()));
        this.typeMapping.put(HttpServletRequest.class, (RequestParameterMapping)new HttpServletRequestParameterMapping());
        this.typeMapping.put(HttpServletResponse.class, (RequestParameterMapping)new HttpServletResponseParameterMapping());
        this.typeMapping.put(ServletConfig.class, (RequestParameterMapping)new ServletConfigParameterMapping());
        this.typeMapping.put(byte[].class, (RequestParameterMapping)new ByteArrayParameterMapping());
    }

    public RequestParameterMapping getMapping(Class<?> type) {
        Object mapping = this.typeMapping.get(type);
        if (mapping == null) {
            if (type.isPrimitive() || type.getPackage().getName().startsWith("java")) {
                return new UnsupportedParameterMapping(type);
            }
            mapping = new BeanValidationParameterMapping(this.messageResource, type);
        }
        this.logger.debug("FSVLD-LOGD009", new Object[]{type.getName(), mapping.getClass().getName()});
        return mapping;
    }
}

