/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.mapping.internal;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.internal.BeanParameterMapping;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.ValidationErrors;
import com.small_it_office.flatserve.validator.internal.ValidationRuleList;
import com.small_it_office.flatserve.validator.processor.internal.ParameterValidationProcessorFactory;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationParameterMapping
extends BeanParameterMapping {
    private MessageResource messageResource;
    private ThreadLocal<RequestContext> threadLocalContext = new ThreadLocal();
    private ParameterValidationProcessorFactory processorFactory;
    private Logger logger = LoggerFactory.getInstance().getLogger(((Object)((Object)this)).getClass());

    public BeanValidationParameterMapping(MessageResource messageResource, Class<?> beanType) {
        super(beanType);
        this.messageResource = messageResource;
        this.processorFactory = new ParameterValidationProcessorFactory(messageResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mapParameter(RequestContext context, Annotation[] annotations) {
        Object result;
        this.threadLocalContext.set(context);
        try {
            result = super.mapParameter(context, annotations);
            ValidationErrors errors = (ValidationErrors)context.getAttribute("varidator.errors");
            if (errors.hasError()) {
                this.logger.debug("FSVLD-LOGD007", new Object[]{this.getBeanType().getName()});
                Object var5_5 = null;
                return var5_5;
            }
        }
        finally {
            this.threadLocalContext.remove();
        }
        return result;
    }

    protected void processNullParameter(Object bean, Field field, String requestParamName) {
        super.processNullParameter(bean, field, requestParamName);
        field.setAccessible(true);
        try {
            this.setValueToField(bean, field, requestParamName, null);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    protected void setValueToField(Object bean, Field field, String paramName, String[] paramValues) throws IllegalAccessException {
        RequestContext context = this.threadLocalContext.get();
        Annotation[] annotations = field.getAnnotations();
        ValidationRuleList ruleList = ValidationRuleList.assignRules(annotations, this.messageResource);
        Object value = this.processorFactory.get(field.getType()).process(context, ruleList, paramName, annotations);
        if (value != null || !field.getType().isPrimitive()) {
            field.set(bean, value);
        }
    }
}

