/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.internal;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.validator.OnValidationError;
import com.small_it_office.flatserve.validator.ValidationErrorResponse;
import com.small_it_office.flatserve.validator.ValidationErrorResponseException;
import com.small_it_office.flatserve.validator.ValidationErrors;
import com.small_it_office.flatserve.validator.ValidatorConfig;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ValidatorHttpServiceExecutor
implements HttpServiceExecutor {
    private static final int PLUGIN_PRIORITY = 256;
    private ValidationErrorResponse defaultErrorResponse;
    private HttpServiceExecutor executor;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public Object execute(RequestContext context, Method method, Object[] params, Object service) {
        ValidationErrors errors = (ValidationErrors)context.getAttribute("varidator.errors");
        if (!errors.hasError()) {
            return this.executor.execute(context, method, params, service);
        }
        this.logger.info("FSVLD-LOGI007", new Object[0]);
        OnValidationError annotation = method.getAnnotation(OnValidationError.class);
        if (annotation == null) {
            Object result;
            this.logger.info("FSVLD-LOGI008", new Object[]{this.defaultErrorResponse.getClass().getName()});
            try {
                result = this.defaultErrorResponse.responseValidationError(errors, context.getHttpServletRequest(), context.getHttpServletResponse(), context.getServletConfig());
            }
            catch (IOException e) {
                throw new ValidationErrorResponseException(Message.get((String)"FSVLD-ERR008", (Object[])new Object[0]), e);
            }
            this.logger.info("FSVLD-LOGI009", new Object[]{this.defaultErrorResponse.getClass().getName()});
            return result;
        }
        String methodName = annotation.value();
        Method errorMethod = this.reflectErrorResponseMethod(service, methodName);
        Object[] parameters = this.createErrorResponseMethodParams(context, errorMethod);
        Object result = this.executeErrorResponseMethod(service, errorMethod, parameters);
        return result;
    }

    private Method reflectErrorResponseMethod(Object service, String methodName) {
        Method[] declaredMethods = service.getClass().getDeclaredMethods();
        Method errorMethod = null;
        for (Method declaredMethod : declaredMethods) {
            if (!Modifier.isPublic(declaredMethod.getModifiers()) || !methodName.equals(declaredMethod.getName())) continue;
            errorMethod = declaredMethod;
            break;
        }
        if (errorMethod == null) {
            throw new ValidationErrorResponseException(Message.get((String)"FSVLD-ERR003", (Object[])new Object[]{service.getClass().getName(), methodName}));
        }
        this.logger.debug("FSVLD-LOGD001", new Object[]{errorMethod.getName()});
        return errorMethod;
    }

    private Object[] createErrorResponseMethodParams(RequestContext context, Method errorMethod) {
        Class<?>[] paramClasses = errorMethod.getParameterTypes();
        Object[] parameters = new Object[paramClasses.length];
        this.logger.debug("FSVLD-LOGD002", new Object[]{errorMethod.getName()});
        for (int i = 0; i < paramClasses.length; ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("FSVLD-LOGD003", new Object[]{errorMethod.getName(), i + 1, paramClasses[i].getName()});
            }
            if (paramClasses[i] == ValidationErrors.class) {
                parameters[i] = context.getAttribute("varidator.errors");
                continue;
            }
            if (paramClasses[i] == HttpServletRequest.class) {
                parameters[i] = context.getHttpServletRequest();
                continue;
            }
            if (paramClasses[i] == HttpServletResponse.class) {
                parameters[i] = context.getHttpServletResponse();
                continue;
            }
            if (paramClasses[i] == ServletConfig.class) {
                parameters[i] = context.getServletConfig();
                continue;
            }
            if (paramClasses[i].isPrimitive()) {
                throw new ValidationErrorResponseException(Message.get((String)"FSVLD-ERR004", (Object[])new Object[]{errorMethod.getDeclaringClass().getName(), errorMethod.getName()}));
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("FSVLD-LOGW001", new Object[]{errorMethod.getDeclaringClass().getName(), errorMethod.getName(), paramClasses[i].getName()});
        }
        return parameters;
    }

    private Object executeErrorResponseMethod(Object service, Method errorMethod, Object[] parameters) {
        Object result;
        this.logger.info("FSVLD-LOGI010", new Object[]{service.getClass().getName(), errorMethod.getName()});
        try {
            result = errorMethod.invoke(service, parameters);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new ValidationErrorResponseException(Message.get((String)"FSVLD-ERR005", (Object[])new Object[0]), cause);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
        this.logger.info("FSVLD-LOGI011", new Object[]{service.getClass().getName(), errorMethod.getName()});
        return result;
    }

    public boolean nest() {
        return true;
    }

    public void init(Config config) {
        ValidatorConfig validatorConfig = (ValidatorConfig)config.getOptionalConfig(ValidatorConfig.class);
        this.defaultErrorResponse = validatorConfig.getDefaultErrorResponse();
        this.logger.debug("FSVLD-LOGD005", new Object[]{this.defaultErrorResponse.getClass().getName()});
    }

    public void setNestedObject(PluginPart o) {
        this.executor = (HttpServiceExecutor)o;
    }

    public int priority() {
        return 256;
    }

    ValidationErrorResponse getDefaultErrorResponse() {
        return this.defaultErrorResponse;
    }

    HttpServiceExecutor getNestedObject() {
        return this.executor;
    }
}

