/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.transition.internal;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.transition.AllowedTokens;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.reflect.Method;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionChecker {
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public boolean check(RequestContext context, Class<?> serviceClass, Method serviceMethod) {
        AllowedTokens annotation = serviceMethod.getAnnotation(AllowedTokens.class);
        if (annotation == null) {
            this.logger.debug("FSTRC-LOGD001", new Object[]{serviceClass.getName(), serviceMethod.getName()});
            return true;
        }
        HttpSession session = context.getHttpServletRequest().getSession(false);
        if (session == null) {
            this.logger.info("FSTRC-LOGI001", new Object[0]);
            return false;
        }
        String currentToken = (String)session.getAttribute("com.small_it_office.flatserve.transition.token");
        if (currentToken == null) {
            this.logger.info("FSTRC-LOGI002", new Object[0]);
            return false;
        }
        boolean result = this.compareToken(annotation, currentToken);
        if (!result) {
            this.logger.info("FSTRC-LOGI003", new Object[]{currentToken, serviceMethod.getName()});
        }
        return result;
    }

    private boolean compareToken(AllowedTokens annotation, String currentToken) {
        String[] allowedTokens = annotation.tokens();
        String[] allowedTokensStartsWith = annotation.tokensStartsWith();
        for (String allowedToken : allowedTokens) {
            if (!currentToken.equals(allowedToken)) continue;
            this.logger.debug("FSTRC-LOGD002", new Object[]{currentToken});
            return true;
        }
        for (String allowedTokenHead : allowedTokensStartsWith) {
            if (!currentToken.startsWith(allowedTokenHead)) continue;
            this.logger.debug("FSTRC-LOGD003", new Object[]{currentToken, allowedTokenHead});
            return true;
        }
        return false;
    }
}

