/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.transition.internal;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.transition.TransitionConfig;
import com.small_it_office.flatserve.transition.WrongTransitionHook;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.reflect.Method;

public class TransitionCheckHttpServiceExecutor
implements HttpServiceExecutor {
    private static final int PLUGIN_PRIORITY = 64;
    private HttpServiceExecutor executor;
    private WrongTransitionHook hook;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public Object execute(RequestContext context, Method method, Object[] params, Object service) {
        if ("true".equals(context.getAttribute("transition.checkresult"))) {
            return this.executor.execute(context, method, params, service);
        }
        this.logger.info("FSTRC-LOGI006", new Object[0]);
        return this.executeWrongTransitionHook(context);
    }

    private Object executeWrongTransitionHook(RequestContext context) {
        String hookName = null;
        if (this.logger.isInfoEnabled()) {
            hookName = this.hook.getClass().getName();
        }
        this.logger.info("FSTRC-LOGI004", new Object[]{hookName});
        Object result = this.hook.wrongTransitionOccured(context.getHttpServletRequest(), context.getHttpServletResponse(), context.getServletConfig());
        this.logger.info("FSTRC-LOGI005", new Object[]{hookName});
        return result;
    }

    public boolean nest() {
        return true;
    }

    public void init(Config config) {
        TransitionConfig transitionConfig = (TransitionConfig)config.getOptionalConfig(TransitionConfig.class);
        this.hook = transitionConfig.getHook();
    }

    public void setNestedObject(PluginPart o) {
        this.executor = (HttpServiceExecutor)o;
    }

    public int priority() {
        return 64;
    }
}

