<?php
class exdate {
    var $timestamp = '';
    var $year;
    var $month;
    var $day;
    var $hour;
    var $min;
    var $sec;
    function exdate($mix = null, $arg2 = null, $arg3 = null) {
        if (is_array($mix)) {
            $year = $mix[0];
            $month = $mix[1];
            $day = $mix[2];
            if ($year and $month and $day) {
                $this->timestamp = mktime('0', '0', '0', $month, $day, $year);
            } else {
                die("exdate new() error 年月日を全て指定してください");
            }
        } else if (preg_match('/^([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})/', $mix, $match)) {
            $year = $match[1];
            $month = $match[2];
            $day = $match[3];
            $hour = $match[4];
            $min = $match[5];
            $sec = $match[6];
            if ($year and $month and $day) {
                $this->timestamp = mktime($hour, $min, $sec, $month, $day, $year);
            } else {
                die("exdate new() error ただしい日付書式をセットしてください");
            }
        } else if ($mix && $arg2 && $arg3) {
            $year = $mix;
            $month = $arg2;
            $day = $arg3;
            $this->timestamp = mktime('0', '0', '0', $month, $day, $year);
        } else {
            $this->timestamp = time();
        }
        $this->_refresh();
    }
    function _refresh() {
        $this->year = date("Y", $this->timestamp);
        $this->month = date("m", $this->timestamp);
        $this->day = date("d", $this->timestamp);
        $this->hour = date("H", $this->timestamp);
        $this->min = date("i", $this->timestamp);
        $this->sec = date("s", $this->timestamp);
    }
    function today() {
        return array($this->year, $this->month, $this->day);
    }
    function next_day() {
        $year = date("Y", strtotime("+1 day", $this->timestamp));
        $month = date("m", strtotime("+1 day", $this->timestamp));
        $day = date("d", strtotime("+1 day", $this->timestamp));
        return array($year, $month, $day);
    }
    function prev_day() {
        $year = date("Y", strtotime("-1 day", $this->timestamp));
        $month = date("m", strtotime("-1 day", $this->timestamp));
        $day = date("d", strtotime("-1 day", $this->timestamp));
        return array($year, $month, $day);
    }
    function next_month() {
        $year = date("Y", strtotime("+1 month", $this->timestamp));
        $month = date("m", strtotime("+1 month", $this->timestamp));
        $day = date("d", strtotime("+1 month", $this->timestamp));
        return array($year, $month, $day);
    }
    function prev_month() {
        $year = date("Y", strtotime("-1 month", $this->timestamp));
        $month = date("m", strtotime("-1 month", $this->timestamp));
        $day = date("d", strtotime("-1 month", $this->timestamp));
        return array($year, $month, $day);
    }
    function now() {
        return array($this->year, $this->month, $this->day, $this->hour, $this->min, $this->sec);
    }
    function days() {
        return date("t", $this->timestamp);
    }
    function day_of_the_week_en() {
        $week = array(0 => 'Sun', 1 => 'Mon', 2 => 'Tue', 3 => 'Wed', 4 => 'Thu', 5 => 'Fri', 6 => 'Sat');
        $no = date("w", mktime(0, 0, 0, $this->month, $this->day, $this->year));
        return $week[$no];
    }
    function day_of_the_week() {
        $week = array(0 => '日', 1 => '月', 2 => '火', 3 => '水', 4 => '木', 5 => '金', 6 => '土');
        $no = date("w", mktime(0, 0, 0, $this->month, $this->day, $this->year));
        return $week[$no];
    }
    function dayno_of_the_week() {
        $no = date("w", mktime(0, 0, 0, $this->month, $this->day, $this->year));
        return $no;
    }
    function db_now() {
        return sprintf("%04d/%02d/%02d %02d:%02d:%02d", $this->year, $this->month, $this->day, $this->hour, $this->min, $this->sec);
    }
    function db_today() {
        return sprintf("%04d/%02d/%02d", $this->year, $this->month, $this->day);
    }
    function db_prev_day() {
        $year = date("Y", strtotime("-1 day", $this->timestamp));
        $month = date("m", strtotime("-1 day", $this->timestamp));
        $day = date("d", strtotime("-1 day", $this->timestamp));
        return sprintf("%04d/%02d/%02d", $year, $month, $day);
    }
    function db_next_day() {
        $year = date("Y", strtotime("+1 day", $this->timestamp));
        $month = date("m", strtotime("+1 day", $this->timestamp));
        $day = date("d", strtotime("+1 day", $this->timestamp));
        return sprintf("%04d/%02d/%02d", $year, $month, $day);
    }
    function db_prev_month() {
        $year = date("Y", strtotime("-1 month", $this->timestamp));
        $month = date("m", strtotime("-1 month", $this->timestamp));
        $day = date("d", strtotime("-1 month", $this->timestamp));
        return sprintf("%04d/%02d/%02d", $year, $month, $day);
    }
    function db_next_month() {
        $year = date("Y", strtotime("+1 month", $this->timestamp));
        $month = date("m", strtotime("+1 month", $this->timestamp));
        $day = date("d", strtotime("+1 month", $this->timestamp));
        return sprintf("%04d/%02d/%02d", $year, $month, $day);
    }
    function customer_id_today() {
        $year = date("y", $this->timestamp);
        return sprintf("%02d-%02d%02d%02d%02d%02d", $year, $this->month, $this->day, $this->hour, $this->min, $this->sec);
    }
    function timestamp_now() {
        return strtotime("{$this->year}/{$this->month}/{$this->day} {$this->hour}:{$this->min}:{$this->sec}");
    }
    function db_timestamp($db_date) {
        return strtotime("{$db_date}");
    }
    function set($year = '', $month = '', $day = '') {
        if ($year == '') {
            die("yearをセットして下さい");
        }
        if ($month == '') {
            die("monthをセットして下さい");
        }
        if ($day == '') {
            die("dayをセットして下さい");
        }
        $this->timestamp = mktime('0', '0', '0', $month, $day, $year);
        $this->_refresh();
    }
    function set_top_of_month() {
        $this->timestamp = mktime('0', '0', '0', $this->month, 1, $this->year);
        $this->_refresh();
    }
    function set_prev_day() {
        $this->timestamp = strtotime("-1 day", $this->timestamp);
        $this->_refresh();
    }
    function set_next_day() {
        $this->timestamp = strtotime("+1 day", $this->timestamp);
        $this->_refresh();
    }
    function set_prev_month() {
        $this->timestamp = strtotime("-1 month", $this->timestamp);
        $this->_refresh();
    }
    function set_next_month() {
        $this->timestamp = strtotime("+1 month", $this->timestamp);
        $this->_refresh();
    }
} ?>