<?php
 require_once 'PEAR/Validate.php'; define('PEAR_PACKAGEFILE_ERROR_NO_PACKAGEVERSION', 1); define('PEAR_PACKAGEFILE_ERROR_INVALID_PACKAGEVERSION', 2); class PEAR_PackageFile { var $_config; var $_debug; var $_logger = false; var $_rawReturn = false; var $_extractErrors = array(); function PEAR_PackageFile(&$config, $debug = false) { $this->_config = $config; $this->_debug = $debug; } function rawReturn() { $this->_rawReturn = true; } function setLogger(&$l) { $this->_logger = &$l; } function &parserFactory($version) { if (!in_array($version{0}, array('1', '2'))) { $a = false; return $a; } include_once 'PEAR/PackageFile/Parser/v' . $version{0} . '.php'; $version = $version{0}; $class = "PEAR_PackageFile_Parser_v$version"; $a = new $class; return $a; } function getClassPrefix() { return 'PEAR_PackageFile_v'; } function &factory($version) { if (!in_array($version{0}, array('1', '2'))) { $a = false; return $a; } include_once 'PEAR/PackageFile/v' . $version{0} . '.php'; $version = $version{0}; $class = $this->getClassPrefix() . $version; $a = new $class; return $a; } function &fromArray($arr) { if (isset($arr['xsdversion'])) { $obj = &$this->factory($arr['xsdversion']); if ($this->_logger) { $obj->setLogger($this->_logger); } $obj->setConfig($this->_config); $obj->fromArray($arr); return $obj; } if (isset($arr['package']['attribs']['version'])) { $obj = &$this->factory($arr['package']['attribs']['version']); } else { $obj = &$this->factory('1.0'); } if ($this->_logger) { $obj->setLogger($this->_logger); } $obj->setConfig($this->_config); $obj->fromArray($arr); return $obj; } function &fromXmlString($data, $state, $file, $archive = false) { if (preg_match('/<package[^>]+version="([0-9]+\.[0-9]+)"/', $data, $packageversion)) { if (!in_array($packageversion[1], array('1.0', '2.0', '2.1'))) { return PEAR::raiseError('package.xml version "' . $packageversion[1] . '" is not supported, only 1.0, 2.0, and 2.1 are supported.'); } $object = &$this->parserFactory($packageversion[1]); if ($this->_logger) { $object->setLogger($this->_logger); } $object->setConfig($this->_config); $pf = $object->parse($data, $file, $archive); if (PEAR::isError($pf)) { return $pf; } if ($this->_rawReturn) { return $pf; } if (!$pf->validate($state)) {; if ($this->_config->get('verbose') > 0 && $this->_logger && $pf->getValidationWarnings(false) ) { foreach ($pf->getValidationWarnings(false) as $warning) { $this->_logger->log(0, 'ERROR: ' . $warning['message']); } } $a = PEAR::raiseError('Parsing of package.xml from file "' . $file . '" failed', 2, null, null, $pf->getValidationWarnings()); return $a; } if ($this->_logger && $pf->getValidationWarnings(false)) { foreach ($pf->getValidationWarnings() as $warning) { $this->_logger->log(0, 'WARNING: ' . $warning['message']); } } if (method_exists($pf, 'flattenFilelist')) { $pf->flattenFilelist(); } return $pf; } elseif (preg_match('/<package[^>]+version="([^"]+)"/', $data, $packageversion)) { $a = PEAR::raiseError('package.xml file "' . $file . '" has unsupported package.xml <package> version "' . $packageversion[1] . '"'); return $a; } else { if (!class_exists('PEAR_ErrorStack')) { require_once 'PEAR/ErrorStack.php'; } PEAR_ErrorStack::staticPush('PEAR_PackageFile', PEAR_PACKAGEFILE_ERROR_NO_PACKAGEVERSION, 'warning', array('xml' => $data), 'package.xml "' . $file . '" has no package.xml <package> version'); $object = &$this->parserFactory('1.0'); $object->setConfig($this->_config); $pf = $object->parse($data, $file, $archive); if (PEAR::isError($pf)) { return $pf; } if ($this->_rawReturn) { return $pf; } if (!$pf->validate($state)) { $a = PEAR::raiseError('Parsing of package.xml from file "' . $file . '" failed', 2, null, null, $pf->getValidationWarnings()); return $a; } if ($this->_logger && $pf->getValidationWarnings(false)) { foreach ($pf->getValidationWarnings() as $warning) { $this->_logger->log(0, 'WARNING: ' . $warning['message']); } } if (method_exists($pf, 'flattenFilelist')) { $pf->flattenFilelist(); } return $pf; } } function addTempFile($file) { $GLOBALS['_PEAR_Common_tempfiles'][] = $file; } function &fromTgzFile($file, $state) { if (!class_exists('Archive_Tar')) { require_once 'Archive/Tar.php'; } $tar = new Archive_Tar($file); if ($this->_debug <= 1) { $tar->pushErrorHandling(PEAR_ERROR_RETURN); } $content = $tar->listContent(); if ($this->_debug <= 1) { $tar->popErrorHandling(); } if (!is_array($content)) { if (is_string($file) && strlen($file < 255) && (!file_exists($file) || !@is_file($file))) { $ret = PEAR::raiseError("could not open file \"$file\""); return $ret; } $file = realpath($file); $ret = PEAR::raiseError("Could not get contents of package \"$file\"". '. Invalid tgz file.'); return $ret; } if (!count($content) && !@is_file($file)) { $ret = PEAR::raiseError("could not open file \"$file\""); return $ret; } $xml = null; $origfile = $file; foreach ($content as $file) { $name = $file['filename']; if ($name == 'package2.xml') { $xml = $name; break; } if ($name == 'package.xml') { $xml = $name; break; } elseif (preg_match('/package.xml$/', $name, $match)) { $xml = $name; break; } } $tmpdir = System::mktemp('-t ' . $this->_config->get('temp_dir') . ' -d pear'); if ($tmpdir === false) { $ret = PEAR::raiseError("there was a problem with getting the configured temp directory"); return $ret; } PEAR_PackageFile::addTempFile($tmpdir); $this->_extractErrors(); PEAR::staticPushErrorHandling(PEAR_ERROR_CALLBACK, array($this, '_extractErrors')); if (!$xml || !$tar->extractList(array($xml), $tmpdir)) { $extra = implode("\n", $this->_extractErrors()); if ($extra) { $extra = ' ' . $extra; } PEAR::staticPopErrorHandling(); $ret = PEAR::raiseError('could not extract the package.xml file from "' . $origfile . '"' . $extra); return $ret; } PEAR::staticPopErrorHandling(); $ret = &PEAR_PackageFile::fromPackageFile("$tmpdir/$xml", $state, $origfile); return $ret; } function _extractErrors($err = null) { static $errors = array(); if ($err === null) { $e = $errors; $errors = array(); return $e; } $errors[] = $err->getMessage(); } function &fromPackageFile($descfile, $state, $archive = false) { $fp = false; if (is_string($descfile) && strlen($descfile) < 255 && ( !file_exists($descfile) || !is_file($descfile) || !is_readable($descfile) || (!$fp = @fopen($descfile, 'r')) ) ) { $a = PEAR::raiseError("Unable to open $descfile"); return $a; } fclose($fp); $data = file_get_contents($descfile); $ret = &PEAR_PackageFile::fromXmlString($data, $state, $descfile, $archive); return $ret; } function &fromAnyFile($info, $state) { if (is_dir($info)) { $dir_name = realpath($info); if (file_exists($dir_name . '/package.xml')) { $info = PEAR_PackageFile::fromPackageFile($dir_name . '/package.xml', $state); } elseif (file_exists($dir_name . '/package2.xml')) { $info = PEAR_PackageFile::fromPackageFile($dir_name . '/package2.xml', $state); } else { $info = PEAR::raiseError("No package definition found in '$info' directory"); } return $info; } $fp = false; if (is_string($info) && strlen($info) < 255 && (file_exists($info) || ($fp = @fopen($info, 'r'))) ) { if ($fp) { fclose($fp); } $tmp = substr($info, -4); if ($tmp == '.xml') { $info = &PEAR_PackageFile::fromPackageFile($info, $state); } elseif ($tmp == '.tar' || $tmp == '.tgz') { $info = &PEAR_PackageFile::fromTgzFile($info, $state); } else { $fp = fopen($info, 'r'); $test = fread($fp, 5); fclose($fp); if ($test == '<?xml') { $info = &PEAR_PackageFile::fromPackageFile($info, $state); } else { $info = &PEAR_PackageFile::fromTgzFile($info, $state); } } return $info; } $info = PEAR::raiseError("Cannot open '$info' for parsing"); return $info; } }