/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */
package jp.finaluna.api.type.util;

import jp.finaluna.api.exception.FinalunaApplException;
import jp.finaluna.api.type.DateAndTimeType;
import jp.finaluna.api.type.DateType;
import jp.finaluna.api.type.DecimalType;
import jp.finaluna.api.type.IntegerType;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.StringCode;
import jp.finaluna.api.type.TimeType;
import jp.finaluna.api.type.TimestampType;

/**
 * FINALUNA^Ԃ̑ݕϊs߂̌^ϊ[eBeBC^[tF[XB
 * 
 * <p>
 * FINALUNA^Ԃ̑ݕϊs߂̌^ϊ[eBeBNX́ÃC^[tF[XB
 * </p>
 * 
 * @author NTTf[^
 * @version $Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $
 */
@Rcsid("$Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $")
public interface FinalunaTypeConvertUtilDelegate {

    /**
     * <code>StringCode</code><code>IntegerType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public IntegerType toIntegerType(StringCode target);

    /**
     * <code>StringCode</code><code>IntegerType</code>ɕϊB
     * <p>
     * ϊɍۂꂽ񂪂ꍇA<code>FinalunaApplException</code>X[B
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ϊɍۂꂽ񂪂ꍇ
     */
    public IntegerType toIntegerTypeExact(StringCode target) throws FinalunaApplException;

    /**
     * <code>StringCode</code><code>DecimalType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DecimalType toDecimalType(StringCode target);

    /**
     * <code>IntegerType</code><code>DecimalType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DecimalType toDecimalType(IntegerType target);

    /**
     * <code>StringCode</code><code>DecimalType</code>ɕϊB
     * <p>
     * ϊɍۂꂽ񂪂ꍇA<code>FinalunaApplException</code>X[B
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ϊɍۂꂽ񂪂ꍇ
     */
    public DecimalType toDecimalTypeExact(StringCode target) throws FinalunaApplException;

    /**
     * <code>StringCode</code><code>DateAndTimeType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DateAndTimeType toDateAndTimeType(StringCode target);

    /**
     * <code>DateType</code><code>DateAndTimeType</code>ɕϊB
     * <p>
     * b00:00:00Őݒ肷B
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DateAndTimeType toDateAndTimeType(DateType target);

    /**
     * <code>TimestampType</code><code>DateAndTimeType</code>ɕϊB
     * <p>
     * imb͐؂̂ĂB
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DateAndTimeType toDateAndTimeType(TimestampType target);

    /**
     * <code>StringCode</code><code>DateType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DateType toDateType(StringCode target);

    /**
     * <code>DateAndTimeType</code><code>DateType</code>ɕϊB
     * <p>
     * b͐؂̂ĂB
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DateType toDateType(DateAndTimeType target);

    /**
     * <code>TimestampType</code><code>DateType</code>ɕϊB
     * <p>
     * bimb͐؂̂ĂB
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DateType toDateType(TimestampType target);

    /**
     * <code>StringCode</code><code>TimestampType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public TimestampType toTimestampType(StringCode target);

    /**
     * <code>DateAndTimeType</code><code>TimestampType</code>ɕϊB
     * <p>
     * imb000000000Őݒ肷B
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public TimestampType toTimestampType(DateAndTimeType target);

    /**
     * <code>DateType</code><code>TimestampType</code>ɕϊB
     * <p>
     * bimb00:00:00:000000000Őݒ肷B
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public TimestampType toTimestampType(DateType target);

    /**
     * <code>StringCode</code><code>TimeType</code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public TimeType toTimeType(StringCode target);

    /**
     * <code>DateAndTimeType</code><code>TimeType</code>ɕϊB
     * <p>
     * <code>DateAndTimeType</code>̎b̏ԂB
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public TimeType toTimeType(DateAndTimeType target);

    /**
     * <code>TimestampType</code><code>TimeType</code>ɕϊB
     * <p>
     * <code>TimestampType</code>̎b̏ԂB
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public TimeType toTimeType(TimestampType target);

}
