/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type;

import jp.finaluna.api.type.util.DateUtil;
import jp.finaluna.api.type.util.MathUtil;

/**
 * Nێ^B
 * <p>
 * t̔rAҏW\bhBɕێ͔NB ̌^ێ͔NłAPʂԃtB[h ̏͏B ܂ÃNX̗p҂͎ԃtB[hCɂ邱ƂȂA
 * ȓtiNĵ݂rA܂͌vZʂ擾邱ƂłB̌^̕\yyyy-MM-dd`łB
 * </p>
 * 
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public interface DateType extends BaseType, Comparable < DateType >, Copiable < DateType > {

    /**
     * <p>
     * ̓t̓ttB[hɑ΂Aw肳ꂽlŉZsB
     * </p>
     * )t5ꍇ́A<br>
     * 
     * <pre>
     * add(DateUtil.DATE, -5);
     * </pre>
     * 
     * <p>
     * 
     * @param field ttB[h
     * @param amount Zl
     * @return Zst^
     */
    DateType add(DateUtil.Calendar field, int amount);

    /**
     * <p>
     * ̓t̓ttB[hɑ΂Aw肳ꂽlŉZsB
     * </p>
     * 
     * @param field ttB[h
     * @param amount Zl
     * @return Zst^
     */
    DateType add(DateUtil.Calendar field, IntegerType amount);

    /**
     * <p>
     * ̓ť̓tԂB
     * </p>
     * 
     * @return ̓ť̓t
     */
    DateType getFirstDayOfMonth();

    /**
     * <p>
     * ̓ť̓tԂB
     * </p>
     * 
     * @return ̓ť̓t
     */
    DateType getLastDayOfMonth();

    /**
     * <p>
     * ̓t̗jԂB
     * </p>
     * 
     * @return ̓t̗j
     */
    DateUtil.DayOfWeek getWeek();

    /**
     * <p>
     * ̓tAw肵tɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareDate</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareDate rΏۓt
     * @return rΏۓtɂꍇA<code>true</code><br>
     *         rΏۓtOɂꍇA<code>false</code><br>
     *         rΏۓtƓꍇA<code>false</code>
     */
    boolean isAfter(DateType compareDate);

    /**
     * <p>
     * ̓tAw肵tOɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareDate</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareDate rΏۓt
     * @return rΏۓtOɂꍇA<code>true</code><br>
     *         rΏۓtɂꍇA<code>false</code><br>
     *         rΏۓtƓꍇA<code>false</code>
     */
    boolean isBefore(DateType compareDate);

    /**
     * <p>
     * ̓tAw肳ꂽlAElŔ͈͓ɂ邩ǂ肷B
     * </p>
     * <p>
     * JntAIt̋EĺA<code>range</code>Ɏw肳ꂽElɏ]B
     * </p>
     * 
     * @param startDate Jnt
     * @param endDate It
     * @param range El
     * @return w肳ꂽlElŔ͈͓ɂꍇA<code>true</code><br>
     *         ȊȌꍇA <code>false</code>
     */
    boolean isInRange(DateType startDate, DateType endDate, MathUtil.InRange range);

    /**
     * <p>
     * ̓tAw肵tɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareDate</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareDate rΏۓt
     * @return rΏۓtɂꍇA<code>true</code><br>
     *         rΏۓtOɂꍇA<code>false</code><br>
     *         rΏۓtƓꍇA<code>true</code>
     */
    boolean isOnAndAfter(DateType compareDate);

    /**
     * <p>
     * ̓tAw肵tOɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareDate</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareDate rΏۓt
     * @return rΏۓtOɂꍇA<code>true</code><br>
     *         rΏۓtɂꍇA<code>false</code><br>
     *         rΏۓtƓꍇA<code>true</code>
     */
    boolean isOnAndBefore(DateType compareDate);

    /**
     * <p>
     * ̓t̎wtB[hɑ΂Aw肳ꂽlݒ肷B
     * </p>
     * )t1ݒ肷B<br>
     * 
     * <pre>
     * set(DateUtil.DATE, 1);
     * </pre>
     * 
     * <p>
     * Note:<br>
     * tB[h́A10琔A1211ƂĈ܂B
     * 
     * @param field ttB[h
     * @param amount ݒ肷l
     * @return ݒ肵t^
     */
    DateType set(DateUtil.Calendar field, int amount);

    /**
     * <p>
     * ̓t̎wtB[hɑ΂Aw肳ꂽlݒ肷B
     * </p>
     * 
     * @param field ttB[h
     * @param amount ݒ肷l
     * @return ݒ肵t^
     */
    DateType set(DateUtil.Calendar field, IntegerType amount);

    /**
     * <p>
     * ̓t̎wtB[h擾B
     * </p>
     * 
     * @param field ttB[h
     * @return w肵tB[h̒l
     */
    int get(DateUtil.Calendar field);
}
