/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.dao;

import jp.finaluna.api.dto.DTO;
import jp.finaluna.api.exception.FinalunaApplException;
import jp.finaluna.api.type.BaseType;
import jp.finaluna.api.type.Rcsid;

/**
 * Of[^L[wōXV邽߂̃f[^ANZXIuWFNgB
 * 
 * <p>
 * L[ɂāAOf[^PR[hXVB XV͕U̑JVM֒ʒmALbVXVB
 * </p>
 * 
 * <p>
 * L[NXhashCodeyequalsK؂ɎKvB
 * </p>
 * 
 * @param <PK> L[
 * @param <VALUE> R[hDTO
 * @version $Revision: 50655 $ $Date: 2010-12-17 13:18:15 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 50655 $ $Date: 2010-12-17 13:18:15 +0900 $")
public interface EntityUpdateDAO < PK extends BaseType, VALUE extends DTO > extends DAO {

    /**
     * PR[hXVB<br>
     * 
     * <p>
     * ݂̃R[hefromƓl̏ꍇ̂݁AtoɕύXB lłȂꍇOptimisticLockFailureException X[AR[h͍XVȂB
     * </p>
     * 
     * @param from ύXOl
     * @param to ύXl
     * @throws FinalunaOptimisticLockFailureException value̒lύXĂꍇɃX[
     * @throws FinalunaApplException ƖOƂ
     */
    void update(VALUE from, VALUE to) throws FinalunaApplException, FinalunaOptimisticLockFailureException;

    /**
     * PR[hXVB<br>
     * 
     * <p>
     * R[hXVBR[h݂Ȃꍇ͑}B
     * </p>
     * 
     * @param value ύXl
     * @throws FinalunaApplException ƖOƂ
     */
    void forceUpdate(VALUE value) throws FinalunaApplException;

    /**
     * PR[h}B<br>
     * 
     * <p>
     * R[hP}B
     * </p>
     * 
     * @param value }l
     * @throws FinalunaApplException ƖOƂ
     */
    void insert(VALUE value) throws FinalunaApplException;

    /**
     * PR[h폜B<br>
     * 
     * <p>
     * ݂DBR[hevalueƓl̏ꍇ̂݁A폜B lłȂꍇOptimisticLockFailureException X[AR[h͍XVȂB
     * </p>
     * 
     * @param value 폜l
     * @throws FinalunaApplException ƖOƂ
     * @throws FinalunaOptimisticLockFailureException value̒lύXĂꍇɃX[
     */
    void delete(VALUE value) throws FinalunaApplException, FinalunaOptimisticLockFailureException;

    /**
     * PR[h폜B<br>
     * 
     * <p>
     * R[h폜BL[Ŏw肳ꂽR[h𖳏ɍ폜B 폜ΏۃR[h݂ȂꍇOX[ȂB
     * </p>
     * 
     * @param pk 폜郌R[h̃L[
     * @throws FinalunaApplException ƖOƂ
     */
    void forceDelete(PK pk) throws FinalunaApplException;

    /**
     * PR[hXVp擾B<br>
     * 
     * <p>
     *PR[hArbNȂ擾B
     * </p>
     * 
     * @param pk R[h̃L[
     * @return PR[hi[DTO
     * @throws FinalunaApplException ƖOƂ
     */
    VALUE getForUpdate(PK pk) throws FinalunaApplException;
}