/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.blogic;

import jp.finaluna.api.dao.CursorDAO;
import jp.finaluna.api.dao.EntityQueryDAO;
import jp.finaluna.api.dao.EntityUpdateDAO;
import jp.finaluna.api.dao.PageQueryDAO;
import jp.finaluna.api.dao.QueryDAO;
import jp.finaluna.api.dao.StoredProcedureDAO;
import jp.finaluna.api.dao.UpdateDAO;
import jp.finaluna.api.dto.DTO;
import jp.finaluna.api.dto.ParameterDTO;
import jp.finaluna.api.dto.ResponseDTO;
import jp.finaluna.api.dto.ResponseStatusCode;
import jp.finaluna.api.dto.message.Message;
import jp.finaluna.api.exception.FinalunaApplException;
import jp.finaluna.api.type.BaseType;
import jp.finaluna.api.type.ListType;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.StringCode;

/**
 * ƖWbNɕKvȏێReLXgC^tF[XB
 * <p>
 * ̃IuWFNgɂ́AƖWbNFINALUNA^ADTOADAOȂǂ t@Ng@\ƁATu@\(TuƖWbNďoAp[^擾)eՂɎgpׂ̋@\B
 * ƖWbNFINALUNA API񋟂APIgpĎׂɁA ̃ReLXggpFINALUNA APĨCX^X𐶐B
 * </p>
 * 
 * @author NTTf[^
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * 
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public interface Context extends ProcessContext {

    /**
     * ResponseDTO̎擾B
     * <p>
     * DTOR[hResponseDTO𐶐B
     * <p>
     * 
     * @param <D> ResponseDTO
     * @param key DTOR[h
     * @return f[^]IuWFNg
     */
    < D extends ResponseDTO > D createResponseDTO(DTOCode < D > key);

    /**
     * ParameterDTO̎擾B
     * <p>
     * DTOR[hParameterDTO𐶐B
     * <p>
     * 
     * @param <D> ParameterDTO
     * @param key DTOR[h
     * @return f[^]IuWFNg
     */
    < D extends ParameterDTO > D createParameterDTO(DTOCode < D > key);

    /**
     * QueryDAO̎擾B
     * <p>
     * DAOR[hQueryDAO𐶐B
     * <p>
     * 
     * @param <Q> QueryDAO
     * @param key DAOR[h
     * @return f[^ANZXIuWFNg(QueryDAO)
     */
    < Q extends QueryDAO > Q createQueryDAO(DAOCode < Q > key);

    /**
     * UpdateDAO̎擾B
     * <p>
     * DAOR[hUpdateDAO𐶐B
     * <p>
     * 
     * @param <U> UpdateDAO
     * @param key DAOR[h
     * @return f[^ANZXIuWFNg(UpdateDAO)
     */
    < U extends UpdateDAO > U createUpdateDAO(DAOCode < U > key);

    /**
     * PageQueryDAO̎擾B
     * <p>
     * DAOR[hPageQueryDAO𐶐B
     * <p>
     * 
     * @param <P> PageQueryDAO
     * @param key DAOR[h
     * @return f[^ANZXIuWFNg(PageQueryDAO)
     */
    < P extends PageQueryDAO > P createPageQueryDAO(DAOCode < P > key);

    /**
     * CursorDAO̎擾B
     * <p>
     * DAOR[hCursorDAO𐶐B
     * </p>
     * 
     * @param <C> CursorDAO
     * @param key DAOR[h
     * @return f[^ANZXIuWFNg(CursorDAO)
     */
    < C extends CursorDAO > C createCursorDAO(DAOCode < C > key);

    /**
     * bZ[W̎擾B
     * <p>
     * bZ[W𐶐B
     * </p>
     * 
     * @param messageKey bZ[WL[l
     * @param messageArgs bZ[Wߍ݃IuWFNg
     * @return bZ[WێNX
     */
    Message createMessage(String messageKey, Object messageArgs);

    /**
     * X|XXe[^X̎擾B
     * <p>
     * L[烌X|XXe[^X𐶐B
     * <p>
     * 
     * @param key L[l
     * @return X|XXe[^X(ResponseStatusCode)
     */
    ResponseStatusCode createResponseStatusCode(String key);

    /**
     * ƖWbNďoB
     * <p>
     * TuƖWbNĂяoB
     * <p>
     * 
     * @param <REQ> DTO
     * @param <RES> DTO
     * @param request NGXgf[^
     * @param response X|Xf[^
     * @param key rWlXWbNR[h
     * @throws FinalunaApplException O
     */
    < REQ extends DTO, RES extends DTO > void execute(REQ request, RES response, BLogicCode < REQ, RES > key)
            throws FinalunaApplException;

    /**
     * ƖWbNւ̃p[^擾B
     * <p>
     * ƖWbNւ̃p[^擾B
     * </p>
     * 
     * @param key 擾p[^̃L[
     * 
     * @return ƖWbNւ̃p[^
     */
    StringCode getParameter(StringCode key);

    /**
     * ƖWbNւ̃p[^擾B
     * <p>
     * ƖWbNւ̃p[^擾B
     * </p>
     * 
     * @param key 擾p[^̃L[
     * 
     * @return ƖWbNւ̃p[^
     */
    ListType < StringCode > getParameterValues(StringCode key);

    /**
     * DTO̎擾B
     * <p>
     * DTOR[hDTO𐶐B
     * <p>
     * 
     * @param <D> DTO
     * @param key DTOR[h
     * @return f[^]IuWFNg
     */
    < D extends DTO > D createDTO(DTOCode < D > key);

    /**
     * EntityQueryDAO̎擾B
     * <p>
     * DAOR[hEntityQueryDAO𐶐B
     * <p>
     * 
     * @param <PK> L[
     * @param <VALUE> DTO
     * @param <D> EntityQueryDAO
     * @param key DAOR[h
     * @return f[^ANZXIuWFNg(EntityQueryDAO)
     */
    < PK extends BaseType, VALUE extends DTO, D extends EntityQueryDAO < PK, VALUE > > D createEntityQueryDAO(
            DAOCode < D > key);

    /**
     * EntityUpdateDAO̎擾B
     * <p>
     * DAOR[hEntityUpdateDAO𐶐B
     * <p>
     * 
     * @param <PK> L[
     * @param <VALUE> DTO
     * @param <D> EntityUpdateDAO
     * @param key DAOR[h
     * @return f[^ANZXIuWFNg(EntityUpdateDAO)
     */
    < PK extends BaseType, VALUE extends DTO, D extends EntityUpdateDAO < PK, VALUE > > D createEntityUpdateDAO(
            DAOCode < D > key);

    /**
     * StoredProcedureDAO̎擾B
     * <p>
     * DAOR[hStoredProcedureDAO𐶐B
     * <p>
     * 
     * @param <S> StoredProcedureDAO
     * @param key DAOR[h
     * @return f[^ANZXIuWFNg(StoredProcedureDAO)
     */
    < S extends StoredProcedureDAO > S createStoredProcedureDAO(DAOCode < S > key);
}
