
#include "defextern.h"


#ifndef STRICT
    #define STRICT
#endif

#include <windows.h>
#include "mes.h"
#include "initial.h"
#include "file.h"
#include "status.h"



#pragma pack(push)
#pragma pack(1)

typedef struct PictureInfo
{
    long   left, top;  // WJʒu
    long   width;      // 摜̕
    long   height;     //       
    WORD   x_density;  // f̐x
    WORD   y_density;  // f̐x
    short  color;      // Pfbit
    HLOCAL info;       // 摜̃eLXgwb_
} PictureInfo;

#pragma pack(pop)

//---------------------------------------------------------------------------
typedef int (CALLBACK *SPI_PROGRESS)(int, int, long);
typedef int (__stdcall *SPI_GetPluginInfo)(int infono, LPSTR buf,int buflen);
typedef int (__stdcall *SPI_IsSupported)(LPSTR filename, DWORD dw);
typedef int (__stdcall *SPI_GetPictureInfo)(LPSTR buf, long len, 
                            unsigned int flag, struct PictureInfo *lpInfo);
typedef int (__stdcall *SPI_GetPicture)(LPSTR buf, long len, unsigned int flag,
                                     HANDLE *pHBInfo, HANDLE *pHBm,
                        SPI_PROGRESS lpPrgressCallback, long lData);

SPI_GetPluginInfo  GetPluginInfo;
SPI_IsSupported    IsSupported;
SPI_GetPictureInfo GetPictureInfo;
SPI_GetPicture     GetPicture;


HMODULE handle=NULL;


BOOL getFnc();
char *searchSpi(char *ext, char *newdir);
BOOL spiLoadHdl(char *spi, char *dir);



void FreeSpi()
{
	if(handle!=NULL) FreeLibrary(handle);
}


#define jpgSpi_0 "ifjpeg.spi"
char *jpgSpi=jpgSpi_0;
char spi[MAX_PATH];


BOOL test( char *file, char *spi, char *dir)
{
	FreeSpi();
	spiLoadHdl(spi, dir);
	BOOL ans =getFnc();
	
	if(ans)
	{
		DWORD d=(DWORD)getHandle(file);
		if(d!=0)
		{
			if((*IsSupported)(file, d)==0) 
			{
				setstatus("bad");
				ans= FALSE;
			}
			else
			{
				setstatus(getExt(file));
			}
			CloseHandle((HANDLE)d);
		}
	}
	FreeSpi();
	return ans;
}

// gqext KvspiT

BOOL searchSpi(char *file, char *newf, char *path)
{
	char spiext[]="*.spi";
	char buff[40];
	int ans;
	ans =getnextfile(path, spiext, newf, _RESET);
	if( ans ==_END ) 
		return FALSE;
	if( test( file, newf, path) ) 
		return TRUE;
	while( 1 )
	{
		ans =getnextfile(path, spiext, newf, _NEXT);
		if( ans ==_END ) 
		{
			break;
		}
		if( test( file, newf, path) ) 
			return TRUE;
	}
	return FALSE;
}

BOOL spiLoadHdl(char *spi, char *dir)
{
    BOOL ret = FALSE;
	SetCurrentDirectory( dir);
    handle = LoadLibrary( spi );
	return ret;
}

BOOL getFnc()
{
    BOOL ret = FALSE;
    if (handle != NULL) {
        GetPluginInfo  = (SPI_GetPluginInfo) GetProcAddress(handle, "GetPluginInfo");
        IsSupported    = (SPI_IsSupported) GetProcAddress(handle, "IsSupported");
        GetPictureInfo = (SPI_GetPictureInfo) GetProcAddress(handle, "GetPictureInfo");
        GetPicture     = (SPI_GetPicture) GetProcAddress(handle, "GetPicture");
        ret = (IsSupported != NULL) & (GetPictureInfo != NULL) & (GetPicture != NULL);
    }

    return ret;
}


BOOL spiLoad(char *ext)
{
	char spi[MAX_PATH];
	if( searchSpi( ext, spi, getSpiDir()) ==FALSE) return FALSE;
	spiLoadHdl(spi, getSpiDir() );
	return getFnc();
}


BOOL spiLoadTest(char *str)
{
	BOOL ans =spiLoad(str);
	FreeSpi();
	return ans;
}


HBITMAP loadbmp(char *file, HLOCAL &inf, HLOCAL &bm)
{
	if(GetPicture != NULL) 
		(*GetPicture)(file, 0, 0, &inf, &bm, NULL, 1);
	return (HBITMAP) bm;
}
