/*
 * Decompiled with CFR 0.152.
 */
package filebookmarker.bean;

import filebookmarker.bean.Bookmark;
import filebookmarker.util.ElementType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category
extends Bookmark {
    private ArrayList<Bookmark> children;

    public Category(String name) {
        super(name, null);
        this.type = ElementType.CATEGORY;
        this.children = new ArrayList();
    }

    public void addChild(Bookmark child) {
        this.children.add(child);
        child.setParentCategory(this);
    }

    public void removeChild(Bookmark child) {
        this.children.remove(child);
        child.setParentCategory(null);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public Bookmark[] getChildren() {
        return this.children.toArray(new Bookmark[this.children.size()]);
    }

    public List<Bookmark> getChildrenList() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public boolean exist(String checkName) {
        if (this.getName().equals(checkName)) {
            return false;
        }
        if (this.hasChildren()) {
            for (Bookmark category : this.children) {
                if (category.getType() != ElementType.CATEGORY || ((Category)category).exist(checkName)) continue;
                return false;
            }
        }
        return true;
    }
}

