<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.parameters.datatypes
 */
/**
 * @file HexBinaryParameter.php
 * @brief HexBinaryParameter for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: HexBinaryParameter.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * ValidatableSimpleParameter with normailizer.
 * treat param as hexBinary
 */

require_once("ficus/exception/ValidationException.php");
require_once("ficus/parameters/ValidatableSimpleParameter.php");

/**
 * @class Ficus_HexBinaryParameter
 */
class Ficus_HexBinaryParameter extends Ficus_ValidatableSimpleParameter
{
	const TYPENAME = "hexBinary";
	//error indicator for pack
	private $errorIndicator = false;
	
	/**
 	 * construct parameter with name, value, and specific validator.
 	 * @param $name string name of this parameter.
 	 * @param $value string value of this parameter.
 	 * @param $validator array array of Ficus_Validator.
 	 */
 	public function __construct($name, $value = null, $validator = array()){
		parent::__construct($name, self::TYPENAME, $value);
		$this->setValidator($validator);
	}

	/**
	 * check param that associated with simple parameter
	 * @param $parameter array data
	 * @return array validated param
     * @throw Ficus_ValidationException invalidate parameter.
	 */
	public function validate($parameter){
		$value = $parameter["value"];
		$old = set_error_handler(array($this, "errorHandler"), E_WARNING);
		pack("H*", $value);
		restore_error_handler();
		if(empty($value) || $this->errorIndicator === false){
			parent::validate($parameter);
		}else{
			$this->errorIndicator = false;
			throw new Ficus_ValidationException("failed hex decoding {$this->name()}.");
		}			
	}

	/**
	 * error Handler for hexBinary
     *
     * @param $errno string error number.
     * @param $errmsg string error message.
     * @param $filename string file name.
     * @param $linenum string line number.
     * @param $vars string vars.
	 */
	private function errorHandler($errno, $errmsg, $filename, $linenum, $vars){
		if($filename === __FILE__ && $errno == E_WARNING){
		   $this->errorIndicator = true;
		}
	}

    /* !!!! function below here is copied from php.net !!!! */
	//admin[TAKETHISOUT] at torsoft dot no-ip dot com
	//22-Apr-2004 04:01
	/*
here are two functions, some might find them useful (maybe for encoding)
converting string to hex and hex to string:
	*/

	/**
	 * convert string to hex style string
	 * @param $string string to convert
	 * @return string hex style string
	 */
	public static function strhex($string){
		$hex="";
		for ($i=0;$i<strlen($string);$i++)
			$hex.=(strlen(dechex(ord($string[$i])))<2)? "0".dechex(ord($string[$i])): dechex(ord($string[$i]));
		return $hex;
	}

	/**
	 * convert hex style string into origenal string
	 * you can use
	 * pack("H*", $hex);
	 * instead of this function
	 * @param $hex string hex style string
	 * @return string original string
	 */
	public static function hexstr($hex){
		$string="";
		for ($i=0;$i<strlen($hex)-1;$i+=2)
			$string.=chr(hexdec($hex[$i].$hex[$i+1]));
		return $string;
	}
}
?>
