<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.organizer
 */
/**
 * @file HiddenScaffoldOrganizer.php
 * @brief HiddenScaffoldOrganizer.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: HiddenScaffoldOrganizer.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/lang/Assert.php");

/**
 * @class Ficus_HiddenScaffoldOrganizer
 */
class Ficus_HiddenScaffoldOrganizer
extends Ficus_AbstractScaffoldOrganizer{
    const TEMPLATE_PREFIX = "form/";

    /**
     * prefix
     * @return string template prefix
     */
    public function prefix(){
        return parent::prefix() . self::TEMPLATE_PREFIX;
    }

    /**
     * on visit
     * @param $part Ficus_ScaffoldPart part
     */
    protected function onVisit($part){
        $entityName = $part->entity()->getEntityName();
        $this->showHidden($part);
    }

    /**
     * end visit
     * @param $container Ficus_ScaffoldPartsContainer
     */
    public function endVisit($container){
    }

    /**
     * show hidden
     */
    protected function showHidden($hidden){
        if($hidden->value() instanceof Ficus_S2DaoEntity){
            foreach($hidden->parts() as $part){
                $this->showHidden($part);
            }
            return;
        }
        $this->assign("qname", $hidden->qname());
        $this->assign("value", $hidden->value());
        $this->addResult($this->fetch("hidden"));
    }
}
?>