<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file PageActionSet.php
 * @brief page action chain
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: Page.php 17 2007-07-19 13:33:15Z ishitoya $
 */

require_once("ficus/pages/PageConstants.php");
require_once("ficus/pages/PageComponentFactory.php");
require_once("ficus/exception/PropertyNotFoundException.php");
require_once("ficus/exception/MethodNotFoundException.php");

/**
 * @class Ficus_PageActionSet
 */
class Ficus_PageActionSet extends Ficus_Bean{
    protected $set = array();
    protected $current = null;

    /**
     * constructor
     * @param $set array of Ficus_PageActionPair
     */
    public function __construct($set = null){
        if(is_array($set)){
            foreach($set as $pair){
                $this->add($pair);
            }
            reset($this->set);
            $this->current = value($this->set);
        }
    }

    /**
     * set current
     */
    public function setCurrent(){
        $args = func_get_args();
        $pair = $this->getPair($args);
        if($this->isExists($pair) == false){
            throw new Ficus_IllegalArgumentException($pair->__toString() . "is not exists in set");
        }
        $this->current = $pair;
        return $this;
    }

    /**
     * add pair
     */
    public function add(){
        $args = func_get_args();
        $pair = $this->getPair($args);
        if($this->isExists($pair)){
            throw new Ficus_IllegalArgumentException($pair . "is already exists in set");
        }
        $this->set[$pair->__toString()] = $pair;
        $this->setCurrent($pair);
        return $this;
    }

    /**
     * get pair
     */
    public function get(){
        if(empty($args)){
            return $this->get($this->current);
        }
        $args = func_get_args();
        $pair = $this->getPair($args);
        if($this->isExists($pair) == false){
            throw new Ficus_IllegalArgumentException($pair . "is not exists in set");
        }
        return $this->set[$pair->__toString()];
    }

    /**
     * check is exists
     */
    public function isExists(){
        $args = func_get_args();
        $pair = $this->getPair($args);
        return isset($this->set[$pair->__toString()]);
    }        

    /**
     * current
     */
    public function current(){
        return $this->current;
    }

    /**
     * next
     */
    public function next(){
        $args = func_get_args();
        if(empty($args)){
            return $this->next($this->current);
        }
        
        $pair = $this->getPair($args);
        if($this->isExists($pair) == false){
            throw new Ficus_IllegalArgumentException($pair . "is not exists in set");
        }
        
        $target = $pair->__toString();
        $next = null;
        foreach($this->set as $key => $value){
            if($next === true){
                return $value;
            }
            if($target === $key){
                $next = true;
            }
        }
        return null;
    }
    
    /**
     * get previous pair
     */
    public function prev(){
        $args = func_get_args();
        if(empty($args)){
            return $this->prev($this->current);
        }
        
        $pair = $this->getPair($args);
        if($this->isExists($pair) == false){
            throw new Ficus_IllegalArgumentException($pair . "is not exists in set");
        }
        
        $target = $pair->__toString();
        $prev = null;
        foreach($this->set as $key => $value){
            if($target === $key){
                return $prev;
            }
            $prev = $value;
        }
        return null;
    }

    /**
     * get pair from arguments
     */
    protected function getPair($args){
        $num = count($args);
        if($num == 1){
            $pair = array_shift($args);
            Ficus_Assert::isInstanceOf($pair, "Ficus_PageActionPair");
            return $pair;
        }else if($num == 2){
            $page = array_shift($args);
            $action = array_shift($args);
            $pair =  new Ficus_PageActionPair();
            $pair->setPage($page);
            $pair->setAction($action);
            return $pair;
        }
        throw new Ficus_IllegalArgumentException("function add takes 1 or 2 arguments. Ficus_PageActionPair or pagename and actionname argument");
    }
}
?>
