<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.ext.pukiwiki.format
 */
/**
 * @file PukiWikiDefinitionList.php
 * @brief pukiwiki definition list converter
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PukiWikiDefinitionList.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * pukiwiki definition list converter
 */

require_once("ficus/ext/pukiwiki/format/PukiWikiFormat.php");

/**
 * @class Ficus_PukiWikiDefinitionList
 */
class Ficus_PukiWikiDefinitionList extends Ficus_PukiWikiFormat
{
    /**
     * convert string
     * @param $str string target string
     * @return string converted string
     */
    public function convert($str){
        $lines = explode("\n", $str);
        $count = count($lines);
        $datas = array();
        for($i = 0; $i < $count; $i++){
            $line = $lines[$i];
            if(preg_match("/^:([^\|]+?)\|(.*)(~$)?/", $line, $regs)){
                $datas[$regs[1]] = $regs[2];
            }
        }
        return $datas;
    }
}
?>
