<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.models
 */
/**
 * @file S2DaoModelConstants.php
 * @brief S2DaoModelConstants.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: S2DaoModelConstants.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */


/**
 * @class Ficus_S2DaoModelConstants
 */
interface Ficus_S2DaoModelConstants{
    const REGISTRY_PREFIX = "s2dao.prefix";
    const REGISTRY_PACKAGE_MODEL = "s2dao.package.model";
    const REGISTRY_PACKAGE_AUTO = "s2dao.package.auto";
    
    const AUTO_PREFIX = "Auto";
    const DAO_PACKAGE = "dao";
    const DTO_PACKAGE = "dto";
    const ENTITY_PACKAGE = "entity";
    const DAO_SUFFIX = "Dao";
    const DTO_SUFFIX = "Dto";
    const ENTITY_SUFFIX = "Entity";

    const ANNOTATION_FORM = "FORM";
    const ANNOTATION_VIEW = "VIEW";
    const ANNOTATION_EXPAND = "EXPAND";
    const ANNOTATION_TYPE = "TYPE";
    const ANNOTATION_DATATYPE = "DATATYPE";
    const ANNOTATION_LABEL = "LABEL";
    const ANNOTATION_REMARK = "REMARK";
    const ANNOTATION_VALIDATOR = "VALIDATOR";
    const ANNOTATION_COLUMN = "COLUMN";

    const VIEW_IGNORE = "ignore";

    const EXPAND_SEPARATOR = ",";

    const CONTEXT_VIEW = "VIEW";
    const CONTEXT_FORM = "FORM";

    const TYPE_LIST = "list";
    const TYPE_FOREIGN = "foreign";
    const TYPE_DIRECT = "direct";
}
?>
