<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.config
 */
/**
 * @file PropertyRegister.php
 * @brief PropertyRegister for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PropertyRegister.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * PropertyRegister pattern.
 */

require_once("ficus/config/Registry.php");
require_once("ficus/io/PropertyFileReader.php");
require_once("ficus/io/YAMLFileReader.php");

/**
 * @class Ficus_PropertyRegister
 */
class Ficus_PropertyRegister
{
    const YAML = "yaml";
    const INI = "ini";
    
    /**
     * register properties
     * @param $filename string file name of the property file
     * @param $filetype string yaml or ini
     */
    public function regist($filename, $filetype = self::INI){
        if($filetype == self::YAML){
            $properties = Ficus_YAMLFileReader::read($filename);
        }else{
            $properties = Ficus_PropertyFileReader::read($filename);
        }
        foreach($properties as $key => $value){
            if(($old = Ficus_Registry::search($key)) &&
               is_array($old) && is_array($value)){
                $value = array_merge_recursive($old, $value);
            }
            
            Ficus_Registry::regist($key, $value);
        }
    }
}
?>
