<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.collection
 */
/**
 * @file Stack.php
 * @brief Stack for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Stack.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Util Stack collection utility.
 */
/**
 * @class Ficus_Stack
 */
class Ficus_Stack implements IteratorAggregate
{
    /**
     * @var array stack.
     */
    private $stack;

    /**
     * Constructor.
     */
    public function __construct() {
        $this->stack = array();
    }

    /**
     * Push stack.
     *
     * @param $element mixed element.
     * @return Ficus_Stack return this.
     */
    public function push($element) {
        $this->stack[] = $element;
        return $this;
    }

    /**
     * Top of stack.
     *
     * @return mixed top value of stack.
     */
    public function top() {
        return end($this->stack);
    }

    /**
     * Pop stack.
     *
     * @return mixed top value of stack.
     */
    public function pop() {
        return array_pop($this->stack);
    }

    /**
     * Count stack.
     *
     * @return int count stack.
     */
    public function count() {
        return count($this->stack);
    }

    /**
     * Get iterator.
     *
     * @return ArrayIterator
     */
    public function getIterator() {
        return new ArrayObject($this->stack);
    }

    /**
     * Stack to array.
     *
     * @return array array of stack values.
     */
    public function toArray() {
        return clone($stack);
    }
}
?>
