<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.RDF
 */
/**
 * @file ResourceNode.php
 * @brief ResourceNode.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: ResourceNode.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
require_once("ficus/RDF/Node.php");
/**
 * @class Ficus_ResourceNode
 */
interface Ficus_ResourceNode extends Ficus_Node
{

    const RESOURCE_NAMESPACE_SEPARATOR1 = '#';
    const RESOURCE_NAMESPACE_SEPARATOR2 = '/';
    const RESOURCE_NAMESPACE_SEPARATOR3 = ':';

    /**
     * qname.
     *
     * @return Ficus_QName qname.
     */
    public function qname();

    /**
     * resource uri namespace.
     *
     * @return string uri.
     */
    public function uri();

    /**
     * resource uri namespace.
     *
     * @return string uri.
     */
    public function namespace();

    /**
     * resource local part.
     *
     * @return string local part.
     */
    public function localPart();

    /**
     * resource local part.
     *
     * @return string local part.
     */
    public function localName();

    /**
     * Split resource uri to namespace and local part.
     *
     * @param $nodeString string node string.
     * @return Ficus_QName resource qname.
     */
    public static function toQNameByResourceString($nodeString);
}
?>
