<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.validators
 */
/**
 * @file Validatable.php
 * @brief URIValidator for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: URIValidator.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * validate parameter that is URI
 */

require_once("ficus/net/URI.php");
require_once("ficus/validators/Validatable.php");
require_once("ficus/exception/ValidationException.php");

/**
 * @interface Ficus_URIValidator
 */
class Ficus_URIValidator implements Ficus_Validatable
{
	/**
	 * validate parameter
	 * @param $param array parameter to validate
     * @throw Ficus_ValidationException invalidate.
	 */
	public function validate($param){
        $uri = $param['value'];
        if ($uri instanceof Ficus_URI) {
            return;
        }
        try {
            Ficus_URI::create($uri);
        } catch (Ficus_URISyntaxException $e) {
            throw new Ficus_ValidationException("{$param['key']} is not a legal uri.", $e);
        }
	}
}
?>
