<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.organizer
 */
/**
 * @file ViewScaffoldOrganizer.php
 * @brief ViewScaffoldOrganizer.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ViewScaffoldOrganizer.php 17 2007-07-19 13:33:15Z ishitoya $
 *
 */

require_once("ficus/lang/Assert.php");

/**
 * @class Ficus_ViewScaffoldOrganizer
 */
class Ficus_ViewScaffoldOrganizer
extends Ficus_AbstractScaffoldOrganizer{
    const TEMPLATE_PREFIX = "view/";

    /**
     * prefix
     * @return string template prefix
     */
    public function prefix(){
        return parent::prefix() . self::TEMPLATE_PREFIX;
    }

    /**
     * on visit
     * @param $part Ficus_ScaffoldPart part
     */
    protected function onVisit($part){
        $config = $this->mediator->table();
        $entityName = $part->entity()->getEntityName();
        if($part->type() == self::TYPE_DIRECT){
            return;
        }
        if($config->isExcludeProperty($part, self::ACTION_VIEW)){
            return;
        }
        
        $value = null;
        if($part->value() instanceof Ficus_S2DaoEntity){
            if($part->type() == self::TYPE_LIST){
                $key = $part->value()->name();
                if(is_null($key)){
                    $value = "";
                }else{
                    $value = $part->value()->names($part->value()->name());
                }
            }else if($template =
                     Ficus_ScaffoldTemplateParser::getTemplate($part)){
                $value =
                    Ficus_ScaffoldTemplateParser::parse($template, $part);
            }else{
                $value = $this->getChildren($part);
            }
        }else{
            $value = $part->value();
        }

        if($config->isNoLabelProperty($part)){
            $this->assign("nolabel", true);
        } 
        $this->assign("label", $part->label());
        $this->assign("value", $value);
        $result = $this->fetch($this->itemTemplate);
        $this->addResult($result);
    }

    /**
     * get child
     */
    protected function getChildren($part){
        $input = "";
        foreach($part->parts() as $child){
            $result = $this->result;
            $this->result = "";
            $child->accept($this);
            $input = $this->result;
            $this->result = $result;
            $this->assign("nolabel", false);
        }
        $this->assign("result", $input);
        return $this->fetch($this->entityTemplate);
    }
}
?>