<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.container
 */
/**
 * @file ConcreteScaffoldPart.php
 * @brief ConcreteScaffoldPart.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ConcreteScaffoldPart.php 14 2007-07-18 14:55:12Z ishitoya $
 *
 */

require_once("ficus/beans/Bean.php");
require_once("ficus/db/s2dao/models/S2DaoModelConstants.php");

/**
 * @class Ficus_ConcreteScaffoldPart
 */
class Ficus_ConcreteScaffoldPart extends Ficus_Bean
implements Ficus_S2DaoModelConstants, Ficus_ScaffoldPart{
    /**
     * parent
     */
    protected $parent;
    
    /**
     * entity name
     */
    protected $entity;

    /**
     * name of part
     */
    protected $name;

    /**
     * type of part
     */
    protected $type;

    /**
     * validators
     */
    protected $validators = array();

    /**
     * constraint
     */
    protected $constraint = array();

    /**
     * value of the part
     */
    protected $value;

    /**
     * label of the part
     */
    protected $label;

    /**
     * remark of the part
     */
    protected $remark;

    /**
     * settings
     */
    protected $settings;

    /**
     * composite parts
     */
    protected $parts = array();

    /**
     * organize
     * @param $organizer Ficus_ScaffoldOrganizer organizer
     */
    public function accept($organizer){
        $organizer->visit($this);
    }

    /**
     * check is composite part
     * @return boolean true if composite
     */
    public function isComposite(){
        if(empty($this->parts)){
            return false;
        }
        return true;
    }

    /**
     * returns qualified name
     * @return string name
     */
    public function qname(){
        if($this->hasParent()){
            return $this->parent->qname() . "__" . get_class($this->entity) . "_" . $this->name;
        }else{
            return get_class($this->entity) . "_" . $this->name;
        }
    }

    /**
     * check has parent
     * @return boolean true if has parent
     */
    public function hasParent(){
        if(is_null($this->parent)){
            return false;
        }
        return true;
    }
}
?>
