<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file EditScaffoldForeperson.php
 * @brief table manager page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: EditScaffoldForeperson.php 19 2007-07-25 18:20:09Z ishitoya $
 */

require_once("ficus/pages/AbstractPage.php");
require_once("ficus/config/Registry.php");

/**
 * @class Ficus_EditScaffoldForeperson
 */
class Ficus_EditScaffoldForeperson extends Ficus_AbstractScaffoldForeperson{
    protected $entity = null;

    /**
     * get entity
     */
    public function entity(){
        return $this->entity;
    }
    
    /**
     * prepare
     */
    protected function prepare($action){
        if($action === self::DO_DEFAULT){
            $id = $this->mediator->request()->extractAsInt(self::KEY_ID);
            $this->entity =
                $this->mediator->daoManager()->getSingleEntity($id);
        }else{
            $this->entity = $this->mediator->getEntityFromRequest();
        }            
    }
    
    /**
     * edit
     * @param $args array of arguments
     */ 
    public function doDefault(){
        return $this->buildEdit($this->entity);
    }

    /**
     * new 
     * @param $args array of arguments
     */
    public function doChildren(){
        return $this->buildEdit($this->entity);
    }

    /**
     * edit confirm
     * @param $args array of arguments
     */
    public function doConfirm(){
        $container = $this->mediator->getContainer($this->entity);
        
        $organizer =
            $this->mediator->organizerFactory()->createViewOrganizer();
        $organizer->setItemTemplate("row");
        $organizer->setEntityTemplate("table");

        $container->addOrganizers($organizer);
        $container->addOrganizers(
            $this->mediator->organizerFactory()->createHiddenOrganizer());
        $this->mediator->formBean()->setDo(self::DO_SUBMIT);
        $this->mediator->setEntity($this->entity);
        return $container->build();
    }

    /**
     * edit submit
     * @param $args array of arguments
     */
    public function doSubmit(){
        $container = $this->mediator->getContainer($this->entity);
        
        $organizer =
            $this->mediator->organizerFactory()->createViewOrganizer();

        $organizer->setItemTemplate("row");
        $organizer->setEntityTemplate("table");

        $container->addOrganizers($organizer);

        $this->entity->update();

        $this->mediator->setEntity($this->entity);
        return $container->build();
    }

    /**
     * buildNew
     */
    protected function buildEdit($entity){
        $transition = null;
        if($this->mediator->request()->has(self::KEY_TRANSITION)){
            $transition = $this->mediator->request()->extractAsString(
                                                         self::KEY_TRANSITION);
            $this->mediator->table()->setCurrentTransition($transition);
        }
        $container = $this->mediator->getContainer($entity);
        
        $organizer =
            $this->mediator->organizerFactory()->createEditOrganizer();
        $organizer->setItemTemplate("row");
        $organizer->setEntityTemplate("table");

        $container->addOrganizers($organizer);

        $transition = $this->mediator->table()->getNextTransition($transition);
        if($transition == null){
            $this->mediator->formBean()->setDo(self::DO_CONFIRM);
        }else{
            $this->mediator->formBean()->setDo(self::DO_CHILDREN);
            $this->mediator->formBean()->setTransition($transition);
        }
        $this->mediator->setEntity($entity);
        return $container->build();
    }
}    
?>
