<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file PageComponentFactory.php
 * @brief Page component factory
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PageComponentFactory.php 17 2007-07-19 13:33:15Z ishitoya $
 * 
 * Page component factory
 */

require_once("ficus/io/File.php");
require_once("ficus/config/Registry.php");
require_once("ficus/lang/AutoLoad.php");
require_once("ficus/lang/S2ContainerAutoLoad.php");
require_once("ficus/lang/ClassLoaderAutoLoad.php");
require_once("ficus/pages/PageController.php");
require_once("ficus/pages/InlinePageController.php");
require_once("ficus/pages/PageLoader.php");
require_once("ficus/pages/PageTemplateResolver.php");
require_once("ficus/pages/PageConstants.php");
require_once("ficus/pages/beans/PageEnvironmentsBean.php");
require_once("ficus/pages/beans/PageVisitBean.php");
require_once("ficus/lang/Array.php");

/**
 * @class Ficus_PageComponentFactory
 */
class Ficus_PageComponentFactory extends Ficus_S2ContainerComponentFactory
implements Ficus_PageConstants{

    /**
     * dicon file name registry key
     */
    const REGISTRY_DICON_FILENAME = "pages.dicon";

    /**
     * dicon namespace registry key
     */
    const REGISTRY_DICON_NAMESPACE = "pages.namespace";
    
    /**
     * Default dicon file name.
     */
    const DEFAULT_DICON_FILENAME = 'pages.dicon';

    /**
     * dicon namespace.
     */
    const DEFAULT_DICON_NAMESPACE = 'pages.scheme';
    
    /**
     * get Dicon file name from registry
     * @return string dicon filename
     */
    protected function getDiconFileNameRegistry(){
        return self::REGISTRY_DICON_FILENAME;
    }

    /**
     * get Dicon namespace from registry
     * @return string dicon namespace
     */
    protected function getDiconNameSpaceRegistry(){
        return self::REGISTRY_DICON_NAMESPACE;
    }

    /**
     * get dicon file name
     * @return string dicon file name
     */
    protected function getDefaultDiconFileName(){
        return Ficus_File::currentDir()
            ->resolve(self::DEFAULT_DICON_FILENAME)->getPath();
    }
    
    /**
     * get defoult dicon namespace
     * @return string dicon namespace
     */
    protected function getDefaultDiconNameSpace(){
        return self::DEFAULT_DICON_NAMESPACE;
    }

    /**
     * get component
     * @param $name string name of component
     * @param $class string class name
     * @return Ficus_ScaffoldComponentFactory
     */
    public static function getComponent($name, $class = __CLASS__){
        return parent::getComponent($name, $class);
    }
    
    /**
     * check registry
     */
    protected function checkForRegistry(){
        if(Ficus_Registry::search(self::REGISTRY_SMARTY) == false){
            throw new Ficus_PropertyNotFoundException("property " . self::REGISTRY_SMARTY . " must be loaded before ComponentFactory initialization");
        }else if(Ficus_Registry::search(self::REGISTRY_BASE) == false){
            throw new Ficus_PropertyNotFoundException("property " . self::REGISTRY_BASE . " must be loaded before ComponentFactory initialization");
        }else if(Ficus_Registry::search(self::REGISTRY_PREFIXES) == false){
            throw new Ficus_PropertyNotFoundException("property " . self::REGISTRY_PREFIXES . " must be loaded before ComponentFactory initialization");
        }

        if(Ficus_Registry::search(self::REGISTRY_SMARTY_PROPERTIES) == false){
            Ficus_Registry::regist(self::REGISTRY_SMARTY_PROPERTIES,
                                  self::DEFAULT_SMARTY_PROPERTIES);
        }
        if(Ficus_Registry::search(self::REGISTRY_SMARTY_PLUGINS) == false){
            Ficus_Registry::regist(self::REGISTRY_SMARTY_PLUGINS,
                                  self::DEFAULT_SMARTY_PLUGINS);
        }
        if(Ficus_Registry::search(self::REGISTRY_SMARTY_ENV) == false){
            Ficus_Registry::regist(self::REGISTRY_SMARTY_ENV,
                                  self::DEFAULT_SMARTY_ENV);
        }
        if(Ficus_Registry::search(self::REGISTRY_SMARTY_VISIT) == false){
            Ficus_Registry::regist(self::REGISTRY_SMARTY_VISIT,
                                  self::DEFAULT_SMARTY_VISIT);
        }
        if(Ficus_Registry::search(self::REGISTRY_DEFAULT) == false){
            Ficus_Registry::regist(self::REGISTRY_DEFAULT,
                                  self::DEFAULT_DEFAULT);
        }
        if(Ficus_Registry::search(self::REGISTRY_SUFFIX) == false){
            Ficus_Registry::regist(self::REGISTRY_SUFFIX,
                                  self::DEFAULT_SUFFIX);
        }
        if(Ficus_Registry::search(self::REGISTRY_INLINE_SUFFIX) == false){
            Ficus_Registry::regist(self::REGISTRY_INLINE_SUFFIX,
                                  self::DEFAULT_INLINE_SUFFIX);
        }
    }

    /**
     * get Smarty
     * @return Smarty smarty view controller
     */
    public static function getSmarty(){
        return self::getComponent(self::COMPONENT_SMARTY);
    }

    /**
     * get template resolver
     * @return Ficus_PageTemplateResolver template resolver
     */
    public static function getTemplateResolver(){
        return self::getComponent(self::COMPONENT_TEMPLATERESOLVER);
    }

    /**
     * get page loader
     * @return Ficus_PageLoader page loader
     */
    public static function getPageLoader(){
        return self::getComponent(self::COMPONENT_PAGELOADER);
    }

    /**
     * get page controller
     * @return Ficus_PageController controller
     */
    public static function getPageController(){
        return self::getComponent(self::COMPONENT_PAGECONTROLLER);
    }

    /**
     * get page loader
     * @return Ficus_PageLoader page loader
     */
    public static function getInlinePageLoader(){
        return self::getComponent(self::COMPONENT_INLINEPAGELOADER);
    }

    /**
     * get inline page controller
     * @return Ficus_InlinePageController controller
     */
    public static function getInlinePageController(){
        return self::getComponent(self::COMPONENT_INLINEPAGECONTROLLER);
    }

    /**
     * get environment bean
     * @return Ficus_PageEnvironmentsBean
     */
    public static function getEnvBean(){
        return self::getComponent(self::COMPONENT_ENVBEAN);
    }

    /**
     * get visit bean
     * @return Ficus_PageVisitBean
     */
    public static function getVisitBean(){
        return self::getComponent(self::COMPONENT_VISITBEAN);
    }
    
    /**
     * Get Authentication
     */
    public static function getAuthorization($page, $prefix = ""){
        Ficus_Assert::isInstanceOf($page, "Ficus_Page");
        $name = $prefix . $page->getPagename() . "PageAuthorization";
        return self::getComponent($name);
    }
}
?>
