<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file BufferedPages.php
 * @brief abstract buffered page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: BufferedPage.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/pages/PageConstants.php");
require_once("ficus/pages/PageComponentFactory.php");
require_once("ficus/exception/PropertyNotFoundException.php");
require_once("ficus/exception/MethodNotFoundException.php");
require_once("ficus/pages/AbstractPage.php");

/**
 * @class Ficus_Page
 */
abstract class Ficus_BufferedPage extends Ficus_AbstractPage{
    /**
     * @var $fetchOutput boolean
     */
    protected $outputBuffering = false;

    /**
     * @var $buffer string
     */
    protected $buffer = "";
    
    /**
     * caller method
     * @param $name string name of method
     * @param $args array array of parameter
     * @return mixed method result
     */
    public function __call($name, $args){
        $result = parent::__call($name, $args);
        if($this->outputBuffering){
            return $this->buffer;
        }
        return $result;
    }
    
    /**
     * fetch template
     * @param $template string template name
     * @return string fetched string
     */
    protected function fetch($template = null){
        $result = parent::fetch($template);
        if($this->outputBuffering){
            $this->buffer .= $result;
        }
        return $result;
    }

    /**
     * display template
     * @param $template string template name
     * @return mixed return value of display
     */
    protected function display($template = null){
        if($this->outputBuffering){
            return $this->fetch($template);
        }
        return parent::display($template);
    }

    /**
     * set output buffering
     */
    public function enableOutputBuffering(){
        $this->outputBuffering = true;
    }

    /**
     * disable output buffering
     */
    public function disableOutputBuffering(){
        $this->outputBuffering = false;
    }

    /**
     * get buffer
     */
    public function getBuffer(){
        return $this->buffer;
    }

    /**
     * clear buffer
     */
    public function clearBuffer(){
        $this->buffer = "";
    }
}
?>
