<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file URL.php
 * @brief URL for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: URL.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * URL
 */
require_once("ficus/net/HierarchicalURI.php");
require_once("ficus/exception/URISyntaxException.php");
/**
 * @class Ficus_URL
 */
class Ficus_URL extends Ficus_HierarchicalURI {

    /**
     * Authority pattern.
     */
    const AUTHORITY_PATTERN = '/(?:([^@]+)(@))?([^:]+)(?:(:)(.*))?/';

    /**
     * Parse URL.
     *
     * @throw Ficus_URISyntaxException invalid URL.
     */
    protected function parse() {
        parent::parse();
        // URL is absolute URI
        if (preg_match(self::AUTHORITY_PATTERN, $this->authority, $matches)) {
            if (isset($mathces[2]) && $mathces[2] == '@') {
                $this->user = $matches[1];
            }
            $this->host = is_null($matches[3]) ? '' : $matches[3];
            if (isset($matches[4]) && $matches[4] == ':') {
                $this->port = isset($matches[5]) ? $matches[5] : null;
            }
        }
    }

}
?>
