<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file Mailer.php
 * @brief simple mail class
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: Mailer.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * simple mailer
 */

/**
 * @class Ficus_Mailer
 */
class Ficus_Mailer
{
    /**
     * @var $from string from
     */
    private $from;
    /**
     * @var $to string to
     */
    private $to;
    
    /**
     * constructor
     * @param $from string from
     * @param $to string to
     */
    public function __construct($from, $to){
        $this->from = $from;
        $this->to = $to;
    }
    
    /**
     * send a mail to address.
     * @param $subject String subject
     * @param $message String message
     */
    public function send($subject, $message){
        if(empty($this->to) || empty($this->from)){
            throw new Ficus_IllegalArgumentException("to or from is not setted");
        }
        $headers = $this->createHeaders();
        mail($this->to, $subject, $message, $headers);
    }

    /**
     * create headers.
     */
    private function createHeaders(){
        $headers = array();
        $headers[] = "From : " . $this->from;
        return implode('\r\n', $headers);
    }
}
?>
