<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file IRISyntax.php
 * @brief IRISyntax for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: IRISyntax.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * IRISyntax for php
 */
require_once("ficus/net/URISyntax.php");
/**
 * @class Ficus_IRISyntax
 */
class Ficus_IRISyntax extends Ficus_URISyntax {

    /**
     * Get syntax type.
     */
    public function getSyntaxType() {
        return 'IRI';
    }

    /**
     * static constructor.
     */
    public static function createInstance() {
        if (!isset(self::$self)) {
            self::$self = new Ficus_IRISyntax();
        }
        return self::$self;
    }

    /**
     * UCS char ranges.
     */
    protected static $ucschar = array(
        array(   0xA0,  0xD7FF),
        array( 0xF900,  0xFDCF),
        array( 0xFDF0,  0xFFEF),
        array(0x10000, 0x1FFFD),
        array(0x20000, 0x2FFFD),
        array(0x30000, 0x3FFFD),
        array(0x40000, 0x4FFFD),
        array(0x50000, 0x5FFFD),
        array(0x60000, 0x6FFFD),
        array(0x70000, 0x7FFFD),
        array(0x80000, 0x8FFFD),
        array(0x90000, 0x9FFFD),
        array(0xA0000, 0xAFFFD),
        array(0xB0000, 0xBFFFD),
        array(0xC0000, 0xCFFFD),
        array(0xD0000, 0xDFFFD),
        array(0xE1000, 0xEFFFD)
    );

    /**
     * Private use area char ranges.
     */
    protected static $iprivate = array(
        array(  0xE000,   0xF8FF),
        array( 0xF0000,  0xFFFFD),
        array(0x100000, 0x10FFFD)
    );

    /**
     * Constructor.
     */
    protected function __construct() {
    }

    /**
     * Get unreserved chars.
     *
     * IRI can use UCS charactor in some component.
     *
     * @return array of unreserved char ranges.
     */
    public function getUnreservedChars() {
        return array_merge(parent::getUnreservedChars(), self::$ucschar);
    }

    /**
     * Get query chars.
     *
     * IRI can use private charactor in query.
     *
     * @return array of unreserved char ranges.
     */
    public function getQueryChars() {
        return array_merge(self::getFragmentChars(), self::$iprivate);
    }

}
?>
