<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang.reflect
 */
/**
 * @file ReflectionClass.php
 * @brief This class stores class information written in schema
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ReflectionClass.php 2 2007-07-11 10:37:48Z ishitoya $
 */
require_once "ficus/lang/PHPVersion.php";
require_once "ficus/lang/reflect/ReflectionProperty.php";
require_once "ficus/lang/Assert.php";
/**
 * @class Ficus_ReflectionClass
 */
class Ficus_ReflectionClass extends ReflectionClass
{
    /**
     * return *all* properties.
     * all means that parent class's property is included.
     */
    public function getAllProperties(){
        $properties = $this->getProperties();
        $parent = $this->getParentClass();
        if($parent){
            $parentClass = new Ficus_ReflectionClass($parent->getName());
            $parentProperties = $parentClass->getAllProperties();
            $properties = array_merge($properties, $parentProperties);
        }
        return $properties;
    }
    
    /**
     * return Ficus_ReflectionProperty when php version < 5.1.0
     * @return array array of Ficus_ReflectionProperty
     */
    public function getProperties(){
        $properties = parent::getProperties();
        if(Ficus_PHPVersion::isOlderThan("5.1.0")){
            $ret = array();
            foreach($properties as $property){
                $ret[] = new Ficus_ReflectionProperty($this->getName(),
                                                     $property->getName());
            }
            return $ret;
        }
        return $properties;
    }

    /**
     * return Ficus_ReflectionProperty when php version < 5.1.0
     * @param $name string target Parameter name
     * @return Ficus_ReflectionProperty
     */
    public function getProperty($name){
        $property = parent::getProperty($name);
        if(Ficus_PHPVersion::isOlderThan("5.1.0")){
            return new Ficus_ReflectionProperty($this->getName(),
                                               $property->getName());
        }
        return $property;
    }

    /**
     * implements hasMethod
     * @param $name string
     * @return boolean return true, when method $name is exists
     */
    public function hasMethod($name){
        if(Ficus_PHPVersion::isOlderThan("5.1.0")){
            return is_callable($this->getName(), $name);
        }
        return parent::hasMethod($name);
    }
}
?>
