<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.exception
 */
/**
 * @file Exception.php
 * @brief Soya base Exception.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Exception.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Soya base exception.
 */
/**
 * @class Ficus_Exception
 */
class Ficus_Exception extends Exception
{
    /**
     * Cause of exception.
     */
    protected $cause = null;

    /**
     * Constructor.
     */
    public function __construct() {
        $message = null;
        $code = 0;
        foreach (func_get_args() as $arg) {
            if ($arg instanceof Ficus_Exception) {
                $this->cause = $arg;
            } else if (is_string($arg)) {
                $message = $arg;
            } else if (is_numeric($arg)) {
                $code = $arg;
            } else {
                assert(false, "Invalid argument in exception.");
            }
        }
        parent::__construct($message, $code);
    }

    /**
     * Set cause of exception.
     *
     * Set cause of exception.
     *
     * @param $cause Exception cause of exception.
     * @return Ficus_Exception $this
     */
    public function initCause($cause) {
        $this->cause = $cause;
        return $this;
    }

    /**
     * Cause of exception.
     *
     * Cause of exception.
     *
     * @return Exception cause of exception.
     */
    public final function getCause() {
        return $this->cause;
    }

    /**
     * Get stack trace.
     *
     * @return array stack trace.
     */
    public function getStackTraceArray() {
        if ($this->getCause()) {
            return array_merge(array(get_class($this) . ': "' . $this->getMessage() . '"'), $this->getCause()->getStackTraceArray());
        } else {
            return array(get_class($this) . ': "' . $this->getMessage() . '"');
        }
    }

    /**
     * Get stack trace string.
     *
     * @return string stack trace.
     */
    public function getStackTrace() {
        return join(" \n", $this->getStackTraceArray());
    }

    /**
     * create exception string
     *
     * @return string error string
     */
    public function toString(){
        $file = basename($this->getFile()) . ":" . $this->getLine();
        return $file . " : " . $this->getStackTrace();
    }

    /**
     * create exception string
     *
     * @return string error string
     */
    public function __toString(){
        $file = basename($this->getFile()) . ":" . $this->getLine();
        return $file . " : " . $this->getStackTrace();
    }
}
?>
