<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.model.serializer
 */
/**
 * @file S2DaoS2DaoArrayEntityDeserializer.php
 * @brief deserialize Array to Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: S2DaoArrayEntityDeserializer.php 17 2007-07-19 13:33:15Z ishitoya $
 */

require_once "ficus/db/s2dao/models/S2DaoEntity.php";
require_once "ficus/beans/serializer/BeanDeserializer.php";
require_once "ficus/lang/Assert.php";
require_once "ficus/lang/reflect/ReflectionClass.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationProperty.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationClass.php";

/**
 * @class Ficus_S2DaoArrayEntityDeserializer
 */
class Ficus_S2DaoArrayEntityDeserializer
implements Ficus_BeanDeserializer, Ficus_S2DaoModelConstants{
    /**
     * deserialize entity from array
     * @param $data array array to deserialize
     * @param $entity Ficus_S2DaoEntity target entity
     * @return Ficus_S2DaoEntity entity
     */
    public function deserialize($entity, $data){
        $entity = $this->parseArray($entity, $data);
        return $entity;
    }

    /**
     * Deserialize Array to Entity
     * @param $entity Ficus_S2DaoEntity entity to parse
     * @param $data Array array to parse
     * @return Ficus_S2DaoEntity result entity
     * @throw Ficus_IllegalBeanException illegal entity.
     */
    private function parseArray($entity, $data, $parent = null){
        $reader = new Ficus_S2DaoEntityAnnotationReader($entity);
        if($data instanceof stdClass){
            $data = (array)$data;
        }

        $properties = $reader->properties();
        $class = get_class($entity);
        foreach($properties as $property){
            $key = $class . "_" . $property;
            if(is_null($parent) == false){
                $key = $parent . "__" . $key;
            }
            
            $getter = "get" . ucfirst($property);
            $setter = "set" . ucfirst($property);
            if($reader->type($property) == self::TYPE_DIRECT){
                if(preg_match('/^(.*?)Direct$/', $key, $regs) == false){
                    continue;
                }
                $id = $regs[1];
                if($this->isEmpty($data, $id) &&
                   $this->isEmpty($data, $key) == false){
                    $entity->{$setter}((integer)$data[$key]);
                }
            }else if($reader->type($property) == self::TYPE_FOREIGN){
                $prop = $entity->{$getter}();
                $value = $this->parseArray($prop, $data, $key);
                $entity->{$setter}($value);
            }else if($reader->type($property) == self::TYPE_LIST){
                if($this->isEmpty($data, $key) == false){
                    $entity->{$setter . "Direct"}((integer)$data[$key]);
                }
            }else if($this->isEmpty($data, $key) == false){
                $value = $data[$key];
                $entity->{$setter}($value);
            }
        }
        return $entity;
    }

    /**
     * check array key is empty
     * @param $data array of data
     * @param $key string target
     * @return boolean true if empty
     */
    private function isEmpty($data, $key){
        if(isset($data[$key]) == false){
            return true;
        }else if($data[$key] === null ||
                 $data[$key] === ""){
            return true;
        }
        return false;
    }
}
?>
