<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.collection
 */
/**
 * @file Map.php
 * @brief This interface is Map.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: Map.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * This interface implementation is ported from Java Map interface
 * http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/java/ficus/Map.html
 */

/**
 * @interface Ficus_Map
 */
interface Ficus_Map extends Iterator{
    /**
     * add element to Collection
     * @param $key string key of this element
     * @param $element Element to add the Map
     * @return element returns old value if the key had found in the Map
     */
    public function put($key, $element);
    
    /**
     * clear all elements in the Map.
     */
    public function clear();

    /**
     * remove element from the Map
     * @param $key string element to remove
     * @return element returns old value if key exists
     */
    public function remove($key);

    /**
     * get element from the Map
     * @param $key string element to get
     * @return element
     */
    public function get($key);
    
    /**
     * get size of the Map 
     * @return integer size of this Map 
     */
    public function size();

    /**
     * to array
     * @return Array array presentation of Map
     */
    public function toArray();

    /**
     * returns true if Map is empty
     * @return boolean true if the Map is empty
     */
    public function isEmpty();

    /**
     * returns key array from the Map
     * @return Array array of the keys of Map
     */
    public function keys();
    
    /**
     * return value array from the Map
     * @return Array array of the values of Map
     */
    public function values();
}
