<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.subversion
 */
/**
 * @file SVNUpdate.php
 * @brief svn update
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: SVNUpdate.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * executes svn updat
 */

require_once("ficus/exception/IllegalArgumentException.php");
require_once("ficus/cli/subversion/SVNConstants.php");
require_once("ficus/lang/Runtime.php");
/**
 * @class Ficus_SVNUpdate
 */
class Ficus_SVNUpdate implements Ficus_SVNConstants
{
    const COMMAND = "update";

    /**
     * @var $repository string where to update
     */
    private $repository = "";

    /**
     * @var $ignoreExternals boolean wether to use --ignore-externals
     */
    private $ignoreExternals = false;

    /**
     * constructor
     * @param $repository string where to update
     * @param $ignoreExternals boolean use option
     */
    public function __construct($repository, $ignoreExternals = false){
        $this->repository = $repository;
        $this->ignoreExternals = $ignoreExternals;
    }

    /**
     * execute command
     * @return array of Ficus_SVNConstants
     */
    public function execute(){
        if(empty($this->repository)){
            throw new Ficus_IllegalArgumentException("repository is empty");
        }

        $command = $this->createCommand();
        $output = Ficus_Runtime::exec($command);

        $error = $output[Ficus_Runtime::ERROR];
        unset($output[Ficus_Runtime::ERROR]);

        if(empty($error) == false){
            throw new Ficus_IllegalArgumentException("some error occured. message:" . $error);
        }

        return $this->parseResult($output);
    }
    
    /**
     * parse result to status line object array
     * @param $output string result
     * @return array of Ficus_SVNStatusLine
     */
    private function parseResult($output){
        $result = array();
        foreach($output as $line){
            try{
                $result[] = new Ficus_SVNStatusLine($line);
            }catch(Ficus_IllegalArgumentException $e){
                continue;
            }
        }
        $last = $output[count($output) - 1];
        if(preg_match("/[0-9]+/", $last, $regs)){
            $result[self::REVISON] = $regs[0];
        }
        return $output;
    }

    /**
     * create command
     * @return string command
     */
    private function createCommand(){
        $command = self::SVN . " ";
        $command .= self::COMMAND . " ";
        $command .= $this->repository . " ";
        if($this->ignoreExternals){
            $command .= self::IGNORE_EXTERNALS;
        }
        return $command;
    }
}
?>
