<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.phing
 */
/**
 * @file Phing.php
 * @brief svn add
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: Phing.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * executes phing abstract class
 */

require_once("ficus/exception/IllegalArgumentException.php");
require_once("ficus/cli/phing/PhingConstants.php");
require_once("ficus/lang/Runtime.php");
/**
 * @class Ficus_Phing
 */
abstract class Ficus_Phing implements Ficus_PhingConstants
{
    const FILE = "-f";

    /**
     * @var $root string root dir
     */
    protected $root;

    /**
     * @var $buildxml string build file
     */
    protected $buildxml = null;

    /**
     * constructor
     * @param $root string root directory to execute phing
     */
    protected function __construct($root){
        $this->root = $root;
    }

    /**
     * set buildxml
     * @param $buildxml string buildxml name
     */
    public function setBuildXML($buildxml){
        $this->buildxml = $buildxml;
    }

    /**
     * execute
     * @return misc subclass's return value
     */
    public function execute(){
        $preserv = getcwd();
        
        chdir($this->root);
        $result = $this->onExecute();
        chdir($preserv);
        return $result;
    }

    /**
     * create command
     * @return string ./phing -f build.xml
     */
    protected function createCommand(){
        $command = self::PHING . " ";
        if(empty($this->buildxml) == false){
            $command .= self::FILE . " " . $this->buildxml . " ";
        }
        return $command;
    }

    /**
     * execute method
     * @return misc misc
     */
    protected abstract function onExecute();
}
?>
