<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.phing
 */
/**
 * @file AbstractCommandExecutor.php
 * @brief svn add
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractCommandExecutor.php 19 2007-07-25 18:20:09Z ishitoya $
 *
 * executes phing abstract class
 */

require_once("ficus/beans/Bean.php");
require_once("ficus/cli/CommandExecutor.php");

/**
 * @class Ficus_AbstractCommandExecutor
 */
abstract class Ficus_AbstractCommandExecutor
extends Ficus_Bean implements Ficus_CommandExecutor
{
    /**
     * @var $root string root dir
     */
    protected $root;

    /**
     * @var $root string command
     */
    protected $command;

    /**
     * @var $result array of result
     */
    protected $result = array();

    /**
     * @var $error
     */
    protected $error = false;

    /**
     * execute
     * @return misc subclass's return value
     */
    public function execute(){
        if($this->isEmptyCommand()){
            throw new Ficus_NotReadyException("command is not ready for runch");
        }
        if($this->isEmptyRoot() == false){
            $preserv = getcwd();
            chdir($this->root);
        }
        $this->result = $this->onExecute();
        if($this->isEmptyRoot() == false){
            chdir($preserv);
        }
        $result = $this->processResult();
        if($result === false){
            $this->error = true;
        }
        return $result;
    }

    /**
     * execute method
     * @return array of result
     */
    protected function onExecute(){
        return Ficus_Runtime::exec($this->createCommand());
    }

    /**
     * process result
     * @param $result array of result
     */
    protected abstract function processResult();

    /**
     * add option to command string
     */
    protected function addOption($command, $option, $value = null){
        if(is_null($value)){
            $option = preg_replace('/[\/\\\]+/', "/", $option);
            $command .= " " . $option;
        }else{
            $value = preg_replace('/[\/\\\]+/', "/", $value);
            $command .= " " . $option . " " . $value;
        }
        return $command;
    }

    /**
     * get error stream from current result
     * @return string error stream
     */
    public function getErrorStream(){
        if(isset($this->result[self::RESULT_ERROR])){
            return $this->result[self::RESULT_ERROR];
        }
        return "";
    }
}
?>
