<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.serializer
 */
/**
 * @file BeanDeserializerFactory.php
 * @brief deserializer factory
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: BeanDeserializerFactory.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once "ficus/lang/ClassLoader.php";

/**
 * @package ficus.beans.serializer
 * @class Ficus_BeanDeserializerFactory
 */
class Ficus_BeanDeserializerFactory{
    const SIGNATURE = "beans.serializer.Ficus_%sBeanDeserializer";
    
    /**
     * create deserializer
     * @param $bean Ficus_Bean bean to deserialize
     * @return string rdf string
     */
    public function create($data){
        $type = null;
        if(is_array($data)){
            $type = "Array";
        }else if(strpos($data, "<rdf:RDF") !== false){
            if(strstr($data, 'http://soya.guarana.cc/bean/1.0-ns#')){            
                $type = "TypeRDF";
            }else{
                $type = "RDF";
            }
        }else if($data instanceof Exception){
            $type = "Error";
        }
        
        if(is_null($type)){
            throw new Ficus_IllegalArgumentException("deserializer is not found");
        }
        $deserializer = sprintf(self::SIGNATURE, $type);
        return Ficus_ClassLoader::load($deserializer);
    }
}
?>
