<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.analyzer
 */
/**
 * @file AnnotationAnalyzeData.php
 * @brief AnnotationAnalyzeData of PHP.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: AnnotationAnalyzeData.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Annotation Analyze data of PHP.
 */
require_once('ficus/lang/Arrays.php');
require_once('ficus/analyzer/AnalyzeData.php');
/**
 * @class Ficus_AnnotationAnalyzeData
 */
class Ficus_AnnotationAnalyzeData extends Ficus_AnalyzeData {
    /**
     * @var annotation data.
     */
    protected $data;
    /**
     * Constructor.
     *
     * @param $name string name.
     */
    public function __construct($name) { $this->name = $name; }
    /**
     * Set data.
     *
     * @param $data annotation data.
     */
    public function setData($data) { $this->data = $data; }
    /**
     * Get data.
     *
     * @return string of annotation data.
     */
    public function getData() { return $this->data; }
    /**
     * To string.
     *
     * @return string of this.
     */
    public function __toString() {
        return $this->name . ' ' . $this->data . "\n";
    }
}
?>
