<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.RDF
 */
/**
 * @file GraphFactory.php
 * @brief GraphFactory.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: GraphFactory.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
require_once("ficus/RDF/Graph.php");
/**
 * @class Ficus_GraphFactory
 */
interface Ficus_GraphFactory
{
    /**
     * Create graph.
     *
     * @return Ficus_Graph
     */
    public static function createGraph();

    /**
     * Create any node.
     *
     * @return Ficus_AnyNode any node.
     */
    public static function createAnyNode();

    /**
     * Create blank node.
     *
     * @param $name Ficus_QName qname.
     * @return Ficus_BlankNode blank node.
     */
    public static function createBlankNode($name);

    /**
     * Create literal node.
     *
     * @param mixed literal.
     * @return Ficus_LiteralNode literal node.
     */
    public static function createLiteralNode();

    /**
     * Create literal node.
     *
     * @param $literal string literal.
     * @param $type Ficus_LiteralType literal type.
     * @return Ficus_LiteralNode literal node.
     */
    public static function createLiteralNodeByType($literal, $type);

    /**
     * Create string literal node.
     *
     * @param $literal string literal.
     * @return Ficus_LiteralNode string literal node.
     */
    public static function createStringLiteral($literal);

    /**
     * Create typed literal node.
     *
     * @param $literal string literal.
     * @param $typeQName Ficus_QName type qname.
     * @return Ficus_LiteralNode typed literal node.
     */
    public static function createTypedLiteral($literal, $typeQName);

    /**
     * Create plain literal node.
     *
     * @param $literal string literal.
     * @param $lang string lang name.
     * @return Ficus_LiteralNode plain literal node.
     */
    public static function createPlainLiteral($literal, $lang);

    /**
     * Create resource node.
     *
     * @param mixed resource.
     * @return Ficus_ResourceNode resource node.
     */
    public static function createResourceNode();

    /**
     * Create resource node.
     *
     * @param $uri string uri.
     * @param $localPart string local part.
     * @return Ficus_ResourceNode resource node.
     */
    public static function createResourceNodeByUri($uri, $localPart);

    /**
     * Create resource node.
     *
     * @param $qname Ficus_QName
     * @return Ficus_ResourceNode resource node.
     */
    public static function createResourceNodeByQName($qname);

    /**
     * Create literal type.
     *
     * @param $type Ficus_QName type qname.
     * @return Ficus_LiteralType literal type.
     */
    public static function createTyped($type);

    /**
     * Create literal type.
     *
     * @param $type Ficus_QName type qname.
     * @param $isPlain boolean is plain?
     * @return Ficus_LiteralType literal type.
     */
    public static function createLiteralType($type, $isPlain);

    /**
     * Create literal lang.
     *
     * @param $lang string lang.
     * @return Ficus_LiteralType literal lang.
     */
    public static function createLiteralLang($lang);

    /**
     * Create triple.
     *
     * @param $subject Ficus_ResourceNode subject node.
     * @param $predicate Ficus_ResourceNode predicate node.
     * @param $object Ficus_Node object node.
     */
    public static function createTriple($subject, $predicate, $object);

    /**
     * Create quad.
     *
     * @param $name Ficus_ResourceNode name node.
     * @param $subject Ficus_ResourceNode subject node.
     * @param $predicate Ficus_ResourceNode predicate node.
     * @param $object Ficus_Node object node.
     */
    public static function createQuad($name, $subject, $predicate, $object);

    /**
     * Create quad by triple.
     *
     * @param $name string name of triple.
     * @param $triple Ficus_Triple triple.
     * @return Ficus_Quad of quad.
     */
    public static function createQuadByTriple($name, $triple);

}
?>
