<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file EditScaffoldForeperson.php
 * @brief table manager page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: EditScaffoldForeperson.php 14 2007-07-18 14:55:12Z ishitoya $
 */

require_once("ficus/pages/AbstractPage.php");
require_once("ficus/config/Registry.php");

/**
 * @class Ficus_EditScaffoldForeperson
 */
class Ficus_EditScaffoldForeperson extends Ficus_AbstractScaffoldForeperson{
    /**
     * edit
     * @param $args array of arguments
     */ 
    public function doDefault(){
        $id = $this->mediator->request()->extractAsInt(self::KEY_ID);
        $entity = $this->mediator->daoManager()->getSingleEntity($id);
        return $this->buildEdit($entity);
    }

    /**
     * new 
     * @param $args array of arguments
     */
    public function doChildren(){
        $entity = $this->mediator->getEntityFromRequest();
        return $this->buildNew($entity);
    }

    /**
     * edit confirm
     * @param $args array of arguments
     */
    public function doConfirm(){
        $entity = $this->mediator->getEntityFromRequest();
        $container = $this->mediator->getContainer($entity);
        
        $organizer =
            $this->mediator->organizerFactory()->createViewOrganizer();
        $organizer->setItemTemplate("row");
        $organizer->setEntityTemplate("table");

        $container->addOrganizers($organizer);
        $container->addOrganizers(
            $this->mediator->organizerFactory()->createHiddenOrganizer());
        $this->mediator->formBean()->setDo(self::DO_SUBMIT);
        return $container->build();
    }

    /**
     * edit submit
     * @param $args array of arguments
     */
    public function doSubmit(){
        $entity = $this->mediator->getEntityFromRequest();
        $container = $this->mediator->getContainer($entity);
        
        $organizer =
            $this->mediator->organizerFactory()->createViewOrganizer();

        $organizer->setItemTemplate("row");
        $organizer->setEntityTemplate("table");

        $container->addOrganizers($organizer);

        $entity->update();

        return $container->build();
    }

    /**
     * buildNew
     */
    protected function buildEdit($entity){
        $transition = null;
        if($this->mediator->request()->has(self::KEY_TRANSITION)){
            $transition = $this->mediator->request()->extractAsString(
                                                         self::KEY_TRANSITION);
            $this->mediator->table()->setCurrentTransition($transition);
        }
        $container = $this->mediator->getContainer($entity);
        
        $organizer =
            $this->mediator->organizerFactory()->createEditOrganizer();
        $organizer->setItemTemplate("row");
        $organizer->setEntityTemplate("table");

        $container->addOrganizers($organizer);

        $transition = $this->mediator->table()->getNextTransition($transition);
        if($transition == null){
            $this->mediator->formBean()->setDo(self::DO_CONFIRM);
        }else{
            $this->mediator->formBean()->setDo(self::DO_CHILDREN);
            $this->mediator->formBean()->setTransition($transition);
        }
        return $container->build();
    }
}    
?>
