<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package webapps.admin.pages
 */
/**
 * @file ConcretePage.php
 * @brief concreate page.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ConcretePage.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/pages/BufferedPage.php");
require_once("ficus/exception/IllegalArgumentException.php");

/**
 * @class Soya_ConcretePage
 */
class Ficus_ConcretePage extends Ficus_BufferedPage{
    const DEFAULT_MODE = "default";

    /**
     * @var $template template
     */
    protected $template = "";
    
    /**
     * constructor
     * @param $template string template name
     * @param $name string page name
     */
    public function __construct($template, $name){
        $this->template = $template;
        parent::__construct("", $name);
    }
    
    /**
     * get default mode
     * @return string default mode name
     */
    public function getDefaultMode(){
        return self::DEFAULT_MODE;
    }

    /**
     * on called
     * @param $mode string name of mode
     * @param $args array of args of do method
     */
    protected function onDo($mode, $args){
    }

    /**
     * on exception
     * @param $mode string name of mode
     * @param $args array of args of do method
     * @param $exception Exception exception
     */
    protected function onException($mode, $args, $exception){
        $this->assign("exception", $exception);
        $this->display($this->template);
    }
    
    /**
     * show default
     */
    public function doDefault(){
        $this->display($this->template);
        return self::NODISPLAY;
    }
}
?>