<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net.rmi
 */
/**
 * @file FMLRMI.php
 * @brief access to pukiwiki
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: FMLRMI.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * access to pukiwiki
 */

require_once("ficus/net/mail/Mail.php");
require_once("ficus/net/rmi/AbstractRemoteMethodInvocation.php");

/**
 * @class Ficus_FMLRMI
 */
class Ficus_FMLRMI extends Ficus_AbstractRemoteMethodInvocation
{
    const FML_LANGUAGE = "LANGUAGE";
    const FML_PROC = "PROC";
    const FML_MLNAME = "ML";
    const ARCHIVE_MLNAME = "ml_name";
    const ARCHIVE_NUMBER = "ml_no";

    const CMD_NEWML = "newml";
    const LANG_JP = "Japanese";
    
    /**
     * create mailing list
     * @param $name string name of mailing list
     * @param $encoding string encoding if setted, convert response
     */
    public function newML($name, $encoding = null){
        if(empty($name)){
            throw new Ficus_IllegalArgumentException("name must not be empty");
        }else if(preg_match('/^[a-z0-9_]+$/', $_REQUEST["ml_name"]) == false){
            throw new Ficus_IllegalArgumentException("name must be a-z0-9_");
        }

        $request =
            array(self::FML_LANGUAGE => self::LANG_JP,
                  self::FML_PROC     => self::CMD_NEWML,
                  self::FML_MLNAME   => $name);

        $response = $this->invoke($request);
        
        if(is_null($encoding)){
            return $response;
        }else{
            return mb_convert_encoding($response, $encoding, $this->encoding);
        }
    }

    /**
     * get archive
     * @param $name string name of the mailing list
     * @param $no integer number of the archive
     * @return Ficus_Mail mail object
     */
    public function getArchive($name, $no){
        if(empty($name)){
            throw new Ficus_IllegalArgumentException("ml name must not be empty");
        }else if(empty($no)){
            throw new Ficus_IllegalArgumentException("ml number must not be empty");
        }else if(preg_match('/^[0-9]+$/', $no) == false){
            throw new Ficus_IllegalArgumentException("ml number must specified in numbers.");
        }
        
        $request =
            array(self::ARCHIVE_MLNAME => $name,
                  self::ARCHIVE_NUMBER => $no);
        $response = $this->invoke($request);

        $mail = new Ficus_Mail();
        $mail->decode($response);
        return $mail;
    }
}
?>
